/**
 * Copyright (c) 2018, 2021 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 *  Matteo MORELLI      matteo.morelli@cea.fr - Bug #566899
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr - Bug #571655
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.base.file.FileSystemAccessFactory;
import org.eclipse.papyrus.designer.languages.common.base.file.ICleanUntouched;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.robotics.codegen.common.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.core.utils.InstanceUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinitionModel;
import org.eclipse.papyrus.robotics.profile.robotics.components.SystemComponentArchitectureModel;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinitionModel;
import org.eclipse.papyrus.robotics.ros2.base.EnvironmentUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.component.AbstractCompTransformations;
import org.eclipse.papyrus.robotics.ros2.codegen.common.launch.LaunchScript;
import org.eclipse.papyrus.robotics.ros2.codegen.common.message.CreateMsgPackage;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class RosTransformations implements IM2MTrafoCDP {
  private CreateMsgPackage msgPkgCreator;

  /**
   * Create code for a ROS 2 package. The passed pkg is used to
   * identify the ros2 package
   * @param pkg the passed ROS 2 package
   */
  public IProject pkgTrafos(final org.eclipse.uml2.uml.Package pkg) {
    try {
      IProject _xblockexpression = null;
      {
        final LangSpecificTransformations lst = RoboticsTContext.current.lst;
        final IProject project = lst.getProject(PackageTools.getProjectName(TransformationContext.initialSourceRoot));
        IProject _xifexpression = null;
        if ((project != null)) {
          IProject _xblockexpression_1 = null;
          {
            final ArrayList<org.eclipse.uml2.uml.Class> compDefsInPkg = PackageTools.getCompDefs(project);
            final ArrayList<org.eclipse.uml2.uml.Class> compDefsInSys = new ArrayList<org.eclipse.uml2.uml.Class>();
            final ArrayList<org.eclipse.uml2.uml.Class> compDefs = new ArrayList<org.eclipse.uml2.uml.Class>();
            compDefs.addAll(compDefsInPkg);
            final org.eclipse.uml2.uml.Class system = PackageTools.getSystem(project);
            if ((system != null)) {
              List<Property> _compInstanceList = InstanceUtils.getCompInstanceList(system);
              for (final Property part : _compInstanceList) {
                {
                  final Type type = part.getType();
                  compDefsInSys.add(((org.eclipse.uml2.uml.Class) type));
                  boolean _contains = compDefs.contains(type);
                  boolean _not = (!_contains);
                  if (_not) {
                    compDefs.add(((org.eclipse.uml2.uml.Class) type));
                  }
                }
              }
            }
            final IPFileSystemAccess fileAccess = FileSystemAccessFactory.create(project);
            lst.createCompDefBuildFiles(fileAccess, pkg, compDefs, compDefsInPkg, system);
            lst.configureProject(project, MessageUtils.calcDependencies(compDefsInSys));
            if ((system != null)) {
              LaunchScript.generateLaunch(fileAccess, system);
            }
            final AbstractCompTransformations ct = lst.getCompTransformation(fileAccess, project);
            for (final org.eclipse.uml2.uml.Class compDef : compDefsInPkg) {
              ct.componentTrafo(compDef, this.msgPkgCreator);
            }
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(SkillUtils.getUniqueSkills(system));
            boolean _not = (!_isNullOrEmpty);
            if (_not) {
              lst.createSkillRealizationPkg(system, InstanceUtils.getComponentList(system), pkg);
            }
            for (final org.eclipse.uml2.uml.Class compDef_1 : compDefsInPkg) {
              ct.componentCodegen(compDef_1, this.msgPkgCreator);
            }
            final ICleanUntouched cleanup = ((ICleanUntouched) fileAccess);
            IFolder _folder = project.getFolder("src-gen");
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            cleanup.cleanUntouched(_folder, _nullProgressMonitor);
            IFolder _folder_1 = project.getFolder("src-skel");
            NullProgressMonitor _nullProgressMonitor_1 = new NullProgressMonitor();
            cleanup.cleanUntouched(_folder_1, _nullProgressMonitor_1);
            _xblockexpression_1 = TransformationContext.current.project = project;
          }
          _xifexpression = _xblockexpression_1;
        } else {
          throw new TransformationException(ExecuteTransformationChain.USER_CANCEL);
        }
        _xblockexpression = _xifexpression;
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  /**
   * Apply transformation, support three cases
   * 1. User called transformation in a component definition model
   * 	=> apply transformation in that model (only)
   * 2. User called transformation in a component definition model
   * 	=> apply transformation in that model (only)
   * 3. User called transformation in a system architecture
   *  => obtain all components within the system
   */
  @Override
  public void applyTrafo(final M2MTrafo trafo, final org.eclipse.uml2.uml.Package rootPkg) throws TransformationException {
    EnvironmentUtils.waitForSetupJob();
    ApplyProfiles.applyCommonProfile(rootPkg);
    ApplyProfiles.applyCppProfile(rootPkg);
    CreateMsgPackage _createMsgPackage = new CreateMsgPackage();
    this.msgPkgCreator = _createMsgPackage;
    boolean _isApplied = StereotypeUtil.isApplied(rootPkg, ServiceDefinitionModel.class);
    if (_isApplied) {
      this.msgPkgCreator.createMsgPkg(rootPkg);
    } else {
      boolean _isApplied_1 = StereotypeUtil.isApplied(rootPkg, ComponentDefinitionModel.class);
      if (_isApplied_1) {
        final org.eclipse.uml2.uml.Class component = InstanceUtils.getComponentFromPkg(rootPkg);
        if ((component != null)) {
          final org.eclipse.uml2.uml.Package pkg = PackageUtil.getRootPackage(component);
          this.pkgTrafos(pkg);
        }
      } else {
        boolean _isApplied_2 = StereotypeUtil.isApplied(rootPkg, SystemComponentArchitectureModel.class);
        if (_isApplied_2) {
          final org.eclipse.uml2.uml.Class system = InstanceUtils.getSystem(rootPkg);
          if ((system != null)) {
            final ArrayList<org.eclipse.uml2.uml.Package> pkgList = new ArrayList<org.eclipse.uml2.uml.Package>();
            final org.eclipse.uml2.uml.Package systemPkg = PackageUtil.getRootPackage(system);
            pkgList.add(systemPkg);
            List<org.eclipse.uml2.uml.Class> _componentList = InstanceUtils.getComponentList(system);
            for (final org.eclipse.uml2.uml.Class component_1 : _componentList) {
              {
                final org.eclipse.uml2.uml.Package compPkg = PackageUtil.getRootPackage(system);
                boolean _contains = pkgList.contains(compPkg);
                boolean _not = (!_contains);
                if (_not) {
                  pkgList.add(compPkg);
                }
              }
            }
            for (final org.eclipse.uml2.uml.Package pkg_1 : pkgList) {
              this.pkgTrafos(pkg_1);
            }
          }
        } else {
          Activator.log.debug(
            String.format("model %s is neither a component definition or a component assembly", rootPkg.getName()));
        }
      }
    }
  }
}
