/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.component;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Conversions;

public class ComponentTransformationUtils {
    public static void liftFunctions(Class component) {
        ComponentDefinition cd = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)component, ComponentDefinition.class);
        EList _activities = cd.getActivities();
        for (Activity activity : _activities) {
            ComponentTransformationUtils.liftFunctions(activity, component);
        }
    }

    public static void removeActivities(Class component) {
        Activity[] _clone;
        ComponentDefinition cd = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)component, ComponentDefinition.class);
        Activity[] activityArray = _clone = (Activity[])((Activity[])Conversions.unwrapArray((Object)cd.getActivities(), Activity.class)).clone();
        int n = _clone.length;
        int n2 = 0;
        while (n2 < n) {
            Activity activity = activityArray[n2];
            component.getAttribute(null, (Type)activity.getBase_Class()).destroy();
            activity.getBase_Class().destroy();
            ++n2;
        }
    }

    public static void removeTemplateSig(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            if (InteractionUtils.getServiceDefinition((Port)port) == null || InteractionUtils.getTemplateBinding((Interface)InteractionUtils.getServiceDefinition((Port)port)) == null) continue;
            InteractionUtils.getTemplateBinding((Interface)InteractionUtils.getServiceDefinition((Port)port)).destroy();
        }
    }

    public static void liftFunctions(Activity activity, Class component) {
        EList _attributes = activity.getBase_Class().getAttributes();
        for (Property fct : _attributes) {
            Type _type = fct.getType();
            if (!(_type instanceof Behavior)) continue;
            Type _type_1 = fct.getType();
            Behavior fctType = (Behavior)_type_1;
            Function fctSt = (Function)UMLUtil.getStereotypeApplication((Element)fctType, Function.class);
            if (fctSt != null) {
                Function _copy;
                Function copy = _copy = (Function)EcoreUtil.copy((EObject)fctSt);
                component.getOwnedBehaviors().add((Object)fctType);
                fctSt = (Function)StereotypeUtil.applyApp((Element)fctType, Function.class);
                EList _eStructuralFeatures = fctSt.eClass().getEStructuralFeatures();
                for (EStructuralFeature feature : _eStructuralFeatures) {
                    boolean _isChangeable = feature.isChangeable();
                    if (!_isChangeable) continue;
                    fctSt.eSet(feature, copy.eGet(feature));
                }
            } else {
                component.getOwnedBehaviors().add((Object)fctType);
            }
            Operation specification = component.createOwnedOperation(fctType.getName(), null, null);
            fctType.setSpecification((BehavioralFeature)specification);
        }
    }

    public static void removeUnrefFunctions(Class component) {
        PackageableElement[] _clone;
        ComponentDefinition cd = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)component, ComponentDefinition.class);
        ArrayList fctList = new ArrayList();
        EList _activities = cd.getActivities();
        for (Activity activity : _activities) {
            fctList.addAll(activity.getFunctions());
        }
        PackageableElement[] packageableElementArray = _clone = (PackageableElement[])((PackageableElement[])Conversions.unwrapArray((Object)component.getNearestPackage().getPackagedElements(), PackageableElement.class)).clone();
        int n = _clone.length;
        int n2 = 0;
        while (n2 < n) {
            Function fct;
            PackageableElement pe = packageableElementArray[n2];
            if (pe instanceof OpaqueBehavior && (fct = (Function)UMLUtil.getStereotypeApplication((Element)pe, Function.class)) != null && !fctList.contains(fct)) {
                ((OpaqueBehavior)pe).destroy();
            }
            ++n2;
        }
    }

    public static void removePorts(Class component) {
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            port.getType().destroy();
            port.destroy();
        }
    }
}

