/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.cpp.build;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.base.file.ProtSection;
import org.eclipse.papyrus.robotics.codegen.common.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.ComponentUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.cpp.build.CreateCompPackageXML;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CreateCompCMakeLists {
    public static CharSequence createCMakeLists(Package pkg, List<Class> allComponents, List<Class> componentsInPkg, Class system) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("cmake_minimum_required(VERSION 3.5.0)");
        _builder.newLine();
        _builder.append("project(");
        String _pkgName = PackageTools.pkgName((Package)pkg);
        _builder.append(_pkgName);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# Default to C++14");
        _builder.newLine();
        _builder.append("if(NOT CMAKE_CXX_STANDARD)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("set(CMAKE_CXX_STANDARD 14)");
        _builder.newLine();
        _builder.append("endif()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("if(CMAKE_COMPILER_IS_GNUCXX OR CMAKE_CXX_COMPILER_ID MATCHES \"Clang\")");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("add_compile_options(-Wall -Wextra -Wpedantic)");
        _builder.newLine();
        _builder.append("endif()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("find_package(ament_cmake REQUIRED)");
        _builder.newLine();
        List<String> _calcDependencies = CreateCompPackageXML.calcDependencies(pkg, allComponents, componentsInPkg);
        for (String dep_pkg : _calcDependencies) {
            _builder.append("find_package(");
            _builder.append(dep_pkg);
            _builder.append(" REQUIRED)");
            _builder.newLineIfNotEmpty();
        }
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)SkillUtils.getUniqueSkills((Class)system));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("find_package(");
            String _realizationPackageName = SkillUtils.realizationPackageName((Package)pkg);
            _builder.append(_realizationPackageName);
            _builder.append(" REQUIRED)");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("include_directories(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# assure that generated .h files are found");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("${PROJECT_SOURCE_DIR}/src");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("${PROJECT_SOURCE_DIR}/src-gen");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.newLine();
        for (Class component : componentsInPkg) {
            boolean _not_2;
            String compBaseFile = CreateCompCMakeLists.fileName((NamedElement)component);
            _builder.newLineIfNotEmpty();
            boolean _isRegistered = ComponentUtils.isRegistered((Class)component);
            if (_isRegistered) {
                boolean _not_1;
                _builder.append("add_library(");
                String _name = component.getName();
                _builder.append(_name);
                _builder.append("_comp SHARED");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("src-gen/");
                _builder.append(compBaseFile, "\t");
                _builder.append(".cpp");
                boolean _hasExternalCode = ActivityUtils.hasExternalCode((Class)component);
                if (_hasExternalCode) {
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("src/");
                    _builder.append(compBaseFile, "\t");
                    _builder.append(CodeSkeleton.POSTFIX, "\t");
                    _builder.append(".cpp");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append(")");
                _builder.newLine();
                _builder.append("target_compile_definitions(");
                String _name_1 = component.getName();
                _builder.append(_name_1);
                _builder.append("_comp");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("PRIVATE \"");
                String _name_2 = component.getName();
                _builder.append(_name_2, "\t");
                _builder.append("_shared_library\")");
                _builder.newLineIfNotEmpty();
                _builder.append("ament_target_dependencies(");
                String _name_3 = component.getName();
                _builder.append(_name_3);
                _builder.append("_comp");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _msgDependencies = CreateCompCMakeLists.msgDependencies(pkg, component);
                _builder.append((Object)_msgDependencies, "\t");
                _builder.newLineIfNotEmpty();
                boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)SkillUtils.getUniqueSkills((Class)system));
                boolean bl2 = _not_1 = !_isNullOrEmpty_1;
                if (_not_1) {
                    _builder.append("\t");
                    String _realizationPackageName_1 = SkillUtils.realizationPackageName((Package)pkg);
                    _builder.append(_realizationPackageName_1, "\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append(")");
                _builder.newLine();
                _builder.append("rclcpp_components_register_nodes(");
                String _name_4 = component.getName();
                _builder.append(_name_4);
                _builder.append("_comp \"");
                String _pkgName_1 = PackageTools.pkgName((Package)pkg);
                _builder.append(_pkgName_1);
                _builder.append("::");
                String _name_5 = component.getName();
                _builder.append(_name_5);
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("add_executable(");
                String _name_6 = component.getName();
                _builder.append(_name_6);
                _builder.append("_main src-gen/");
                _builder.append(compBaseFile);
                _builder.append("_main.cpp)");
                _builder.newLineIfNotEmpty();
                _builder.append("target_link_libraries(");
                String _name_7 = component.getName();
                _builder.append(_name_7);
                _builder.append("_main ");
                String _name_8 = component.getName();
                _builder.append(_name_8);
                _builder.append("_comp)");
                _builder.newLineIfNotEmpty();
                _builder.append("ament_target_dependencies(");
                String _name_9 = component.getName();
                _builder.append(_name_9);
                _builder.append("_main rclcpp)");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            _builder.append("add_executable(");
            String _name_10 = component.getName();
            _builder.append(_name_10);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("src-gen/");
            _builder.append(compBaseFile, "\t");
            _builder.append(".cpp");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("src-gen/");
            _builder.append(compBaseFile, "\t");
            _builder.append("_main.cpp");
            _builder.newLineIfNotEmpty();
            boolean _hasExternalCode_1 = ActivityUtils.hasExternalCode((Class)component);
            if (_hasExternalCode_1) {
                _builder.append("\t");
                _builder.append("src/");
                _builder.append(compBaseFile, "\t");
                _builder.append(CodeSkeleton.POSTFIX, "\t");
                _builder.append(".cpp");
            }
            _builder.newLineIfNotEmpty();
            _builder.append(")");
            _builder.newLine();
            _builder.append("ament_target_dependencies(");
            String _name_11 = component.getName();
            _builder.append(_name_11);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _msgDependencies_1 = CreateCompCMakeLists.msgDependencies(pkg, component);
            _builder.append((Object)_msgDependencies_1, "\t");
            _builder.newLineIfNotEmpty();
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)SkillUtils.getUniqueSkills((Class)system));
            boolean bl3 = _not_2 = !_isNullOrEmpty_2;
            if (_not_2) {
                _builder.append("\t");
                String _realizationPackageName_2 = SkillUtils.realizationPackageName((Package)pkg);
                _builder.append(_realizationPackageName_2, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append(")");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("# ");
        String _protSection = ProtSection.protSection((String)"dependencies");
        _builder.append(_protSection);
        _builder.newLineIfNotEmpty();
        _builder.append("# ");
        String _protSection_1 = ProtSection.protSection();
        _builder.append(_protSection_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (Class component_1 : componentsInPkg) {
            _builder.append("install(TARGETS");
            _builder.newLine();
            boolean _isRegistered_1 = ComponentUtils.isRegistered((Class)component_1);
            if (_isRegistered_1) {
                _builder.append("\t");
                String _name_12 = component_1.getName();
                _builder.append(_name_12, "\t");
                _builder.append("_main");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _name_13 = component_1.getName();
                _builder.append(_name_13, "\t");
                _builder.append("_comp");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                String _name_14 = component_1.getName();
                _builder.append(_name_14, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("DESTINATION lib/${PROJECT_NAME}");
            _builder.newLine();
            _builder.append(")");
            _builder.newLine();
        }
        if (system != null) {
            _builder.newLine();
            _builder.append("# Install launch files.");
            _builder.newLine();
            _builder.append("install(DIRECTORY");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("launch");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("DESTINATION share/${PROJECT_NAME}/");
            _builder.newLine();
            _builder.append(")");
            _builder.newLine();
        }
        _builder.append("ament_package()");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence msgDependencies(Package model, Class component) {
        StringConcatenation _builder = new StringConcatenation();
        List<Class> compList = Collections.singletonList(component);
        _builder.newLineIfNotEmpty();
        List<String> _calcDependencies = CreateCompPackageXML.calcDependencies(model, compList, compList);
        for (String msg_pkg : _calcDependencies) {
            _builder.append(msg_pkg);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static void generate(IPFileSystemAccess fileAccess, Package pkg, List<Class> allComponents, List<Class> componentsInPkg, Class system) {
        fileAccess.generateFile("CMakeLists.txt", CreateCompCMakeLists.createCMakeLists(pkg, allComponents, componentsInPkg, system).toString());
    }

    public static String fileName(NamedElement ne) {
        return ne.getQualifiedName().replace("::", "/");
    }
}

