/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.component;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.codegen.common.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Create a template for the code that needs to be filled by a developer.
 */
@SuppressWarnings("all")
public class Ros2CodeSkeleton extends CodeSkeleton {
  public Ros2CodeSkeleton(final org.eclipse.uml2.uml.Class component) {
    super(component);
  }

  @Override
  public Operation addConstrOp(final org.eclipse.uml2.uml.Class skeleton) {
    final Operation constructorOp = Constructor.addConstrOp(skeleton);
    Behavior _createOwnedBehavior = this.component.createOwnedBehavior(skeleton.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
    final OpaqueBehavior ob = ((OpaqueBehavior) _createOwnedBehavior);
    constructorOp.getMethods().add(ob);
    ob.getLanguages().add("Python");
    EList<String> _bodies = ob.getBodies();
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super().__init__(instName)");
    _builder.newLine();
    _bodies.add(_builder.toString());
    return constructorOp;
  }

  @Override
  public boolean moveFunction(final org.eclipse.uml2.uml.Class skeleton, final Function function) {
    return super.moveFunction(skeleton, function);
  }
}
