/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.fromsys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.robotics.core.utils.ScanUtils;
import org.eclipse.papyrus.robotics.library.advice.AdviceUtil;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.CommunicationObject;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.DataAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinition;
import org.eclipse.papyrus.robotics.ros2.base.ProcessUtils;
import org.eclipse.papyrus.robotics.ros2.base.Ros2ProcessBuilder;
import org.eclipse.papyrus.robotics.ros2.reverse.Activator;
import org.eclipse.papyrus.robotics.ros2.reverse.fromsys.MessageParser;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ReverseUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ReverseMessages {
    public static final String PATHMAP_ROS2_PRIMITIVE_UML = "pathmap://ROS2_LIBRARY/ros2.primitive.uml";
    IFolder folder;

    public ReverseMessages(IFolder folder) {
        this.folder = folder;
    }

    public void reverseMessages(IProgressMonitor monitor) {
        Ros2ProcessBuilder pbIntf = new Ros2ProcessBuilder(new String[]{"interface", "list"});
        monitor.subTask("read interface list");
        List<MessageParser.MessageEntry> msgList = this.readMsgList(monitor, pbIntf);
        PackageUtil.loadPackage((URI)URI.createURI((String)PATHMAP_ROS2_PRIMITIVE_UML), (ResourceSet)ModelManagement.getResourceSet());
        monitor.beginTask("reverse ROS messages and services", msgList.size());
        for (MessageParser.MessageEntry msg : msgList) {
            monitor.subTask(msg.name);
            this.reverseMsg(msg);
            if (msg.type.equals("msg")) {
                ReverseMessages.createPubSubSvcDefinition(msg);
            } else if (msg.type.equals("srv")) {
                ReverseMessages.createQuerySvcDefinition(msg);
            } else if (msg.type.equals("action")) {
                ReverseMessages.createActionSvcDefinition(msg);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
        }
        ArrayList resources = new ArrayList();
        resources.addAll(ModelManagement.getResourceSet().getResources());
        for (Resource r : resources) {
            try {
                if (!r.getURI().isPlatformResource()) continue;
                r.save(null);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public List<MessageParser.MessageEntry> readMsgList(IProgressMonitor monitor, Ros2ProcessBuilder pb) {
        ArrayList<MessageParser.MessageEntry> msgList = new ArrayList<MessageParser.MessageEntry>();
        try {
            String line;
            Process p = pb.start();
            BufferedReader results = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean error = ProcessUtils.logErrors((Process)p);
            if (error) {
                return msgList;
            }
            List pathMapURIs = ScanUtils.allPathmapModels((String)".servicedef.uml");
            while ((line = results.readLine()) != null) {
                MessageParser.MessageEntry msg = MessageParser.extractMessageEntry(line);
                if (msg != null) {
                    Package pkg;
                    if (ReverseUtils.existsAlready(this.folder, pathMapURIs, msg.pkgName)) {
                        pkg = ReverseMessages.getBasePkg(msg.pkgName);
                        if (pkg == null) {
                            ReverseUtils.loadMessagePackage(this.folder, pathMapURIs, msg.pkgName);
                            pkg = ReverseMessages.getBasePkg(msg.pkgName);
                        }
                    } else {
                        monitor.subTask("create new model for package " + msg.pkgName);
                        pkg = ReverseUtils.createMsgPackage(this.folder, msg.pkgName);
                    }
                    if (pkg == null) {
                        Activator.log.debug("a Model for message package %s exists, but does not define the message package");
                        continue;
                    }
                    boolean added = false;
                    if (msg.type.equals("msg")) {
                        Package msgs = ReverseUtils.getOrCreatePackage(pkg, "msg");
                        added = ReverseUtils.getOrCreateCommObject(msgs, msg.commObjects, msg.name);
                    } else if (msg.type.equals("srv")) {
                        Package srvs = ReverseUtils.getOrCreatePackage(pkg, "srv");
                        added = ReverseUtils.getOrCreateCommObject(srvs, msg.commObjects, String.valueOf(msg.name) + "Req");
                        added = ReverseUtils.getOrCreateCommObject(srvs, msg.commObjects, String.valueOf(msg.name) + "Res") || added;
                    } else if (msg.type.equals("action")) {
                        Package actions = ReverseUtils.getOrCreatePackage(pkg, "action");
                        added = ReverseUtils.getOrCreateCommObject(actions, msg.commObjects, String.valueOf(msg.name) + "Goal");
                        added = ReverseUtils.getOrCreateCommObject(actions, msg.commObjects, String.valueOf(msg.name) + "Res") || added;
                        boolean bl = added = ReverseUtils.getOrCreateCommObject(actions, msg.commObjects, String.valueOf(msg.name) + "Feedback") || added;
                    }
                    if (added) {
                        msgList.add(msg);
                    }
                }
                monitor.worked(1);
                if (monitor.isCanceled()) break;
            }
            results.close();
        }
        catch (IOException exp) {
            Activator.log.error((Throwable)exp);
        }
        return msgList;
    }

    public void reverseMsg(MessageParser.MessageEntry msg) {
        String qMessageName = String.valueOf(msg.pkgName) + "/" + msg.type + "/" + msg.name;
        Ros2ProcessBuilder pb = new Ros2ProcessBuilder(new String[]{"interface", "show", qMessageName});
        List<DataType> commObjects = msg.commObjects;
        try {
            String line;
            Process p = pb.start();
            BufferedReader results = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean error = ProcessUtils.logErrors((Process)p);
            if (error) {
                return;
            }
            int index = 0;
            DataType commObject = commObjects.get(index++);
            String commentStart = "";
            boolean firstDA = false;
            while ((line = results.readLine()) != null) {
                MessageParser.NameType nt;
                String comment = MessageParser.extractComment(line);
                if ((line = MessageParser.filterComment(line)).equals("---")) {
                    commObject = commObjects.get(index++);
                }
                if ((nt = MessageParser.extractNameType(line)) != null) {
                    Property attr;
                    Type umlType;
                    Package pkg;
                    String type = nt.typeName;
                    boolean checkPrimitive = false;
                    if (nt.typePkg != null) {
                        pkg = ReverseMessages.getMessagePkg(nt.typePkg);
                    } else {
                        pkg = ReverseMessages.getMessagePkg(msg.pkgName);
                        checkPrimitive = true;
                    }
                    Type type2 = umlType = pkg != null ? pkg.getOwnedType(type) : null;
                    if (umlType == null && checkPrimitive) {
                        pkg = (Package)ElementUtils.getQualifiedElementFromRS((Element)commObject, (String)"primitive");
                        Type type3 = umlType = pkg != null ? pkg.getOwnedType(type) : null;
                    }
                    if (umlType == null) {
                        Activator.log.debug("Cannot find type for " + nt.typeName);
                    }
                    if ((attr = commObject.getOwnedAttribute(nt.name, null)) == null) {
                        attr = commObject.createOwnedAttribute(nt.name, null);
                    }
                    attr.setType(umlType);
                    if (nt.upper != null) {
                        attr.setLower(0);
                        attr.setUpper(nt.upper.intValue());
                    }
                    if (nt.defaultValue != null) {
                        attr.setIsStatic(true);
                        if (type.equals("string")) {
                            LiteralString ls = (LiteralString)attr.createDefaultValue(null, umlType, UMLPackage.Literals.LITERAL_STRING);
                            ls.setValue(nt.defaultValue);
                        } else {
                            LiteralInteger li = (LiteralInteger)attr.createDefaultValue(null, umlType, UMLPackage.Literals.LITERAL_INTEGER);
                            li.setValue(MessageParser.extractNumber(nt.defaultValue));
                        }
                    }
                    if (comment != null) {
                        DataAttribute da = (DataAttribute)StereotypeUtil.applyApp((Element)attr, DataAttribute.class);
                        da.setDescription(comment);
                    }
                    firstDA = true;
                    continue;
                }
                if (firstDA || comment == null) continue;
                if (commentStart.length() > 0) {
                    commentStart = String.valueOf(commentStart) + " ";
                }
                commentStart = String.valueOf(commentStart) + comment;
            }
            if (commentStart.length() > 0) {
                CommunicationObject co = (CommunicationObject)UMLUtil.getStereotypeApplication((Element)commObject, CommunicationObject.class);
                co.setDescription(commentStart);
            }
            results.close();
        }
        catch (IOException exp) {
            Activator.log.error((Throwable)exp);
        }
    }

    public static void createPubSubSvcDefinition(MessageParser.MessageEntry msg) {
        DataType commObject = msg.commObjects.get(0);
        Package pkg = ReverseMessages.getServiceDefPkg(msg.pkgName);
        PackageUtil.getRootPackage((Element)commObject).getMember("robotics");
        Classifier commPattern = AdviceUtil.getPattern((Element)commObject, (String)"robotics::commpatterns::PubSub");
        if (commPattern != null) {
            Interface serviceDef = pkg.createOwnedInterface(null);
            TemplateSignature signature = commPattern.getOwnedTemplateSignature();
            TemplateBinding binding = serviceDef.createTemplateBinding(signature);
            String name = "P_" + commObject.getName();
            for (TemplateParameter parameter : signature.getOwnedParameters()) {
                TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                substitution.setFormal(parameter);
                substitution.setActual((ParameterableElement)commObject);
            }
            serviceDef.setName(name);
            ((XMLResource)serviceDef.eResource()).setID((EObject)serviceDef, String.valueOf(pkg.getName()) + "/" + name);
            StereotypeUtil.apply((Element)serviceDef, ServiceDefinition.class);
        }
    }

    public static void createQuerySvcDefinition(MessageParser.MessageEntry msg) {
        DataType commObjectReq = msg.commObjects.get(0);
        DataType commObjectRes = msg.commObjects.get(1);
        Package pkg = ReverseMessages.getServiceDefPkg(msg.pkgName);
        Classifier queryCommPattern = AdviceUtil.getPattern((Element)commObjectReq, (String)"robotics::commpatterns::Query");
        if (queryCommPattern != null) {
            Interface serviceDef = pkg.createOwnedInterface(null);
            TemplateSignature signature = queryCommPattern.getOwnedTemplateSignature();
            TemplateBinding binding = serviceDef.createTemplateBinding(signature);
            String name = "Q_";
            String reqName = commObjectReq.getName();
            name = reqName.endsWith("Req") ? String.valueOf(name) + reqName.substring(0, reqName.length() - 3) : String.valueOf(name) + reqName;
            boolean first = true;
            for (TemplateParameter parameter : signature.getOwnedParameters()) {
                TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                substitution.setFormal(parameter);
                substitution.setActual((ParameterableElement)(first ? commObjectReq : commObjectRes));
                first = false;
            }
            serviceDef.setName(name);
            ((XMLResource)serviceDef.eResource()).setID((EObject)serviceDef, String.valueOf(pkg.getName()) + "/" + name);
            StereotypeUtil.apply((Element)serviceDef, ServiceDefinition.class);
        }
    }

    public static void createActionSvcDefinition(MessageParser.MessageEntry msg) {
        DataType commObjGoal = msg.commObjects.get(0);
        DataType commObjResult = msg.commObjects.get(1);
        DataType commObjFeedback = msg.commObjects.get(2);
        Package pkg = ReverseMessages.getServiceDefPkg(msg.pkgName);
        Classifier actionCommPattern = AdviceUtil.getPattern((Element)commObjGoal, (String)"robotics::commpatterns::Action");
        if (actionCommPattern != null) {
            Interface serviceDef = pkg.createOwnedInterface(null);
            TemplateSignature signature = actionCommPattern.getOwnedTemplateSignature();
            TemplateBinding binding = serviceDef.createTemplateBinding(signature);
            String name = "A_";
            String reqName = commObjGoal.getName();
            name = reqName.endsWith("Goal") ? String.valueOf(name) + reqName.substring(0, reqName.length() - 4) : String.valueOf(name) + reqName;
            int i = 0;
            for (TemplateParameter parameter : signature.getOwnedParameters()) {
                TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                substitution.setFormal(parameter);
                substitution.setActual((ParameterableElement)(i == 0 ? commObjGoal : (i == 1 ? commObjResult : commObjFeedback)));
                ++i;
            }
            serviceDef.setName(name);
            ((XMLResource)serviceDef.eResource()).setID((EObject)serviceDef, String.valueOf(pkg.getName()) + "/" + name);
            StereotypeUtil.apply((Element)serviceDef, ServiceDefinition.class);
        }
    }

    public static Package getBasePkg(String pkgName) {
        return (Package)ElementUtils.getQualifiedElementFromRS((ResourceSet)ModelManagement.getResourceSet(), (String)pkgName);
    }

    public static Package getMessagePkg(String pkgName) {
        Package pkg = ReverseMessages.getBasePkg(pkgName);
        if (pkg != null) {
            return ReverseUtils.getOrCreatePackage(pkg, "msg");
        }
        return null;
    }

    public static Package getServiceDefPkg(String pkgName) {
        Package pkg = ReverseMessages.getBasePkg(pkgName);
        if (pkg != null) {
            return ReverseUtils.getOrCreatePackage(pkg, "svcdefs");
        }
        return null;
    }

    public static enum MessageType {
        MESSAGE,
        SERVICE,
        ACTION,
        INTERFACES;

    }
}

