/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.safety.riskanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BodyRegion implements Enumerator
{
    SKULL_FOREHEAD(0, "Skull_Forehead", "Skull_Forehead"),
    FACE(1, "Face", "Face"),
    NECK(2, "Neck", "Neck"),
    BAC_KSHOULDERS(3, "BacK_Shoulders", "BacK_Shoulders"),
    CHEST(4, "Chest", "Chest"),
    ABDOMEN(5, "Abdomen", "Abdomen"),
    PELVIS(6, "Pelvis", "Pelvis"),
    UPPER_ARMS_ELBOW_JOINTS(7, "UpperArms_ElbowJoints", "UpperArms_ElbowJoints"),
    LOWER_ARMS_WRIST_JOINTS(8, "LowerArms_WristJoints", "LowerArms_WristJoints"),
    HANDS_FINGERS(9, "Hands_Fingers", "Hands_Fingers"),
    THIGHS_KNEES(10, "Thighs_Knees", "Thighs_Knees"),
    LOWER_LEGS(11, "LowerLegs", "LowerLegs");

    public static final int SKULL_FOREHEAD_VALUE = 0;
    public static final int FACE_VALUE = 1;
    public static final int NECK_VALUE = 2;
    public static final int BAC_KSHOULDERS_VALUE = 3;
    public static final int CHEST_VALUE = 4;
    public static final int ABDOMEN_VALUE = 5;
    public static final int PELVIS_VALUE = 6;
    public static final int UPPER_ARMS_ELBOW_JOINTS_VALUE = 7;
    public static final int LOWER_ARMS_WRIST_JOINTS_VALUE = 8;
    public static final int HANDS_FINGERS_VALUE = 9;
    public static final int THIGHS_KNEES_VALUE = 10;
    public static final int LOWER_LEGS_VALUE = 11;
    private static final BodyRegion[] VALUES_ARRAY;
    public static final List<BodyRegion> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BodyRegion[]{SKULL_FOREHEAD, FACE, NECK, BAC_KSHOULDERS, CHEST, ABDOMEN, PELVIS, UPPER_ARMS_ELBOW_JOINTS, LOWER_ARMS_WRIST_JOINTS, HANDS_FINGERS, THIGHS_KNEES, LOWER_LEGS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BodyRegion get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BodyRegion result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BodyRegion getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BodyRegion result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BodyRegion get(int value) {
        switch (value) {
            case 0: {
                return SKULL_FOREHEAD;
            }
            case 1: {
                return FACE;
            }
            case 2: {
                return NECK;
            }
            case 3: {
                return BAC_KSHOULDERS;
            }
            case 4: {
                return CHEST;
            }
            case 5: {
                return ABDOMEN;
            }
            case 6: {
                return PELVIS;
            }
            case 7: {
                return UPPER_ARMS_ELBOW_JOINTS;
            }
            case 8: {
                return LOWER_ARMS_WRIST_JOINTS;
            }
            case 9: {
                return HANDS_FINGERS;
            }
            case 10: {
                return THIGHS_KNEES;
            }
            case 11: {
                return LOWER_LEGS;
            }
        }
        return null;
    }

    private BodyRegion(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

