/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  CEA LIST - Initial API and implementation
 */
package org.eclipse.papyrus.robotics.xtext.compdef.ui.contribution;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Entity;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class UnparseCompDef {
  public static CharSequence getCompDefText(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("component ");
    String _name = clazz.getName();
    _builder.append(_name);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      EList<Port> _ownedPorts = clazz.getOwnedPorts();
      for(final Port port : _ownedPorts) {
        _builder.append("\t");
        _builder.append("port ");
        String _name_1 = port.getName();
        _builder.append(_name_1, "\t");
        _builder.append(" ");
        String _provided = UnparseCompDef.getProvided(port);
        _builder.append(_provided, "\t");
        String _required = UnparseCompDef.getRequired(port);
        _builder.append(_required, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<Property> _ownedAttributes = clazz.getOwnedAttributes();
      for(final Property attribute : _ownedAttributes) {
        _builder.append("\t");
        final Type type = attribute.getType();
        _builder.newLineIfNotEmpty();
        {
          if (((type != null) && StereotypeUtil.isApplied(type, Activity.class))) {
            _builder.append("\t");
            _builder.append("activity ");
            String _name_2 = type.getName();
            _builder.append(_name_2, "\t");
            ValueSpecification _defaultValue = attribute.getDefaultValue();
            _builder.append(_defaultValue, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    final org.eclipse.uml2.uml.Class paramClass = ParameterUtils.getParameterClass(clazz);
    _builder.newLineIfNotEmpty();
    {
      if ((paramClass != null)) {
        {
          EList<Property> _attributes = paramClass.getAttributes();
          for(final Property parameter : _attributes) {
            _builder.append("\t");
            _builder.append("parameter ");
            String _name_3 = parameter.getName();
            _builder.append(_name_3, "\t");
            String _typeStr = UnparseCompDef.getTypeStr(parameter);
            _builder.append(_typeStr, "\t");
            String _defaultValueStr = UnparseCompDef.getDefaultValueStr(parameter);
            _builder.append(_defaultValueStr, "\t");
            String _comment = UnparseCompDef.getComment(parameter);
            _builder.append(_comment, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public static String getProvided(final Port port) {
    final EList<Interface> provideds = port.getProvideds();
    int _size = provideds.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      final Interface provided = provideds.get(0);
      if (((provided != null) && (provided.getName() != null))) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("provides ");
        String _qualifiedName = provided.getQualifiedName();
        _builder.append(_qualifiedName);
        return _builder.toString();
      }
    }
    return "";
  }

  public static String getRequired(final Port port) {
    final EList<Interface> requireds = port.getRequireds();
    int _size = requireds.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      final Interface required = requireds.get(0);
      if (((required != null) && (required.getName() != null))) {
        StringConcatenation _builder = new StringConcatenation();
        {
          int _length = UnparseCompDef.getProvided(port).length();
          boolean _greaterThan_1 = (_length > 0);
          if (_greaterThan_1) {
            _builder.append(" ");
          }
        }
        _builder.append("requires ");
        String _qualifiedName = required.getQualifiedName();
        _builder.append(_qualifiedName);
        return _builder.toString();
      }
    }
    return "";
  }

  public static String getDefaultValueStr(final Property attribute) {
    final ValueSpecification value = attribute.getDefaultValue();
    if ((value != null)) {
      String strVal = value.stringValue();
      if ((strVal != null)) {
        boolean _not = (!((strVal.charAt(0) >= '0') && (strVal.charAt(0) <= '9')));
        if (_not) {
          strVal = (("\"" + strVal) + "\"");
        }
        return (" = " + strVal);
      }
    }
    return "";
  }

  public static String getTypeStr(final Property attribute) {
    Type _type = attribute.getType();
    boolean _tripleNotEquals = (_type != null);
    if (_tripleNotEquals) {
      String _qualifiedName = attribute.getType().getQualifiedName();
      return (": " + _qualifiedName);
    }
    return "";
  }

  public static String getComment(final Property parameter) {
    final Entity entity = UMLUtil.<Entity>getStereotypeApplication(parameter, Entity.class);
    if (((entity != null) && (entity.getDescription() != null))) {
      String _description = entity.getDescription();
      return ("\t// " + _description);
    } else {
      return "";
    }
  }
}
