/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Francois Le Fevre (CEA LIST) francois.le-fevre@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.sysml14.blocks;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.sysml14.blocks.internal.impl.BlockImpl;
import org.eclipse.papyrus.sysml14.portsandflows.FlowProperty;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;



/**
 * 
 */
public class BlockCustomImpl extends BlockImpl {

	/**
	 * 
	 * @see org.eclipse.papyrus.sysml14.blocks.internal.impl.BlockImpl#getReferences()
	 * @pap.req org.eclipse.papyrus.sysml14#REQ-SYSML14-Block-References
	 *
	 * @return the list of Property linked
	 */
	@Override
	public EList<Property> getReferences() { 
		BasicEList<Property> propertyEList = new BasicEList<>();
	
		if (getBase_Class() != null) {
			EList<Property> ownedAttributes = getBase_Class().getOwnedAttributes(); 
			for (Property property : ownedAttributes) {
				if (org.eclipse.uml2.uml.AggregationKind.COMPOSITE!=property.getAggregation().getValue()) { 
					Type type = property.getType();
					Block stereotypeApplication = UMLUtil.getStereotypeApplication(type, Block.class);
					if (stereotypeApplication != null){
						propertyEList.add(property);
					}
				}
			}
		}

		return new BasicEList.UnmodifiableEList<>(propertyEList.size(), propertyEList.toArray());
	}
	
	/**
	 * 
	 * @see org.eclipse.papyrus.sysml14.blocks.internal.impl.BlockImpl#getParts()
	 *
	 * @return the list of Property linked
	 */
	@Override
	public EList<Property> getParts() { 
		BasicEList<Property> propertyEList = new BasicEList<>();
	
		if (getBase_Class() != null) {
			EList<Property> ownedAttributes = getBase_Class().getOwnedAttributes(); 
			for (Property property : ownedAttributes) {
				if (org.eclipse.uml2.uml.AggregationKind.COMPOSITE==property.getAggregation().getValue()) { 
					Type type = property.getType();
					Block stereotypeApplication = UMLUtil.getStereotypeApplication(type, Block.class);
					if (stereotypeApplication != null){
						propertyEList.add(property);
					}
				}
			}
		}

		return new BasicEList.UnmodifiableEList<>(propertyEList.size(), propertyEList.toArray());
	}
	
	/**
	 * 
	 * @see org.eclipse.papyrus.sysml14.blocks.internal.impl.BlockImpl#getFlowProperties()
	 * @pap.req org.eclipse.papyrus.sysml14#REQ-001
	 *
	 * @return the list of FlowProperties
	 */
	@Override
	public EList<Property> getFlowProperties() { 
		BasicEList<Property> propertyEList = new BasicEList<>();
	
		if (getBase_Class() != null) {
			EList<Property> ownedAttributes = getBase_Class().getOwnedAttributes(); 
			for (Property property : ownedAttributes) {
				FlowProperty stereotypeApplication = UMLUtil.getStereotypeApplication(property, FlowProperty.class);
				if (stereotypeApplication != null){
					propertyEList.add(property);
				}
			}
		}

		return new BasicEList.UnmodifiableEList<>(propertyEList.size(), propertyEList.toArray());
	}
	
}
