/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each operation of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 *
 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplateFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='markupdocumentstructuretemplate'"
 * @generated
 */
public interface MarkupEMFDocumentStructureTemplatePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNAME = "documentstructuretemplate"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/model2doc/markup/emf/1.0.0/documentstructuretemplate"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNS_PREFIX = "markup.emf.documentstructuretemplate"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	MarkupEMFDocumentStructureTemplatePackage eINSTANCE = org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.MarkupEMFDocumentStructureTemplatePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.EAttributeInMarkupToFileImpl <em>EAttribute In Markup To File</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.EAttributeInMarkupToFileImpl
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.MarkupEMFDocumentStructureTemplatePackageImpl#getEAttributeInMarkupToFile()
	 * @generated
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE = 0;

	/**
	 * The feature id for the '<em><b>EAttribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__EATTRIBUTE = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE__EATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Generate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__GENERATE = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Generate Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__GENERATE_TITLE = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Custom Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__CUSTOM_TITLE = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Generate Branch Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__GENERATE_BRANCH_CONDITION = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Generate If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__GENERATE_IF_EMPTY = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Default Text If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__DEFAULT_TEXT_IF_EMPTY = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Input Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__INPUT_FORMAT = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Output Fomat</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE__OUTPUT_FOMAT = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>EAttribute In Markup To File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE_FEATURE_COUNT = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Build EAttribute Value Label</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE___BUILD_EATTRIBUTE_VALUE_LABEL__OBJECT = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE___BUILD_EATTRIBUTE_VALUE_LABEL__OBJECT;

	/**
	 * The operation id for the '<em>Get EAttribute Values</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE___GET_EATTRIBUTE_VALUES__EOBJECT = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE___GET_EATTRIBUTE_VALUES__EOBJECT;

	/**
	 * The operation id for the '<em>Build Part Template Title</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE___BUILD_PART_TEMPLATE_TITLE__EOBJECT = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Generate Branch</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE___GENERATE_BRANCH__EOBJECT = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>EAttribute In Markup To File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int EATTRIBUTE_IN_MARKUP_TO_FILE_OPERATION_COUNT = DocumentStructureTemplatePackage.EATTRIBUTE_TEMPLATE_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate <em>IMarkup To File Body Part Template</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.MarkupEMFDocumentStructureTemplatePackageImpl#getIMarkupToFileBodyPartTemplate()
	 * @generated
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE = 1;

	/**
	 * The feature id for the '<em><b>Generate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE__GENERATE = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE__GENERATE;

	/**
	 * The feature id for the '<em><b>Generate Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE__GENERATE_TITLE = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE__GENERATE_TITLE;

	/**
	 * The feature id for the '<em><b>Custom Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE__CUSTOM_TITLE = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE__CUSTOM_TITLE;

	/**
	 * The feature id for the '<em><b>Generate Branch Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE__GENERATE_BRANCH_CONDITION = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE__GENERATE_BRANCH_CONDITION;

	/**
	 * The feature id for the '<em><b>Generate If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE__GENERATE_IF_EMPTY = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE__GENERATE_IF_EMPTY;

	/**
	 * The feature id for the '<em><b>Default Text If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE__DEFAULT_TEXT_IF_EMPTY = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE__DEFAULT_TEXT_IF_EMPTY;

	/**
	 * The feature id for the '<em><b>Input Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE__INPUT_FORMAT = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Output Fomat</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE__OUTPUT_FOMAT = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>IMarkup To File Body Part Template</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE_FEATURE_COUNT = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Build Part Template Title</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE___BUILD_PART_TEMPLATE_TITLE__EOBJECT = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE___BUILD_PART_TEMPLATE_TITLE__EOBJECT;

	/**
	 * The operation id for the '<em>Generate Branch</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE___GENERATE_BRANCH__EOBJECT = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE___GENERATE_BRANCH__EOBJECT;

	/**
	 * The number of operations of the '<em>IMarkup To File Body Part Template</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_TO_FILE_BODY_PART_TEMPLATE_OPERATION_COUNT = DocumentStructureTemplatePackage.IBODY_SECTION_PART_TEMPLATE_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.EAttributeInMarkupToFile <em>EAttribute In Markup To File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>EAttribute In Markup To File</em>'.
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.EAttributeInMarkupToFile
	 * @generated
	 */
	EClass getEAttributeInMarkupToFile();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate <em>IMarkup To File Body Part Template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>IMarkup To File Body Part Template</em>'.
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate
	 * @generated
	 */
	EClass getIMarkupToFileBodyPartTemplate();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate#getInputFormat <em>Input Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Input Format</em>'.
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate#getInputFormat()
	 * @see #getIMarkupToFileBodyPartTemplate()
	 * @generated
	 */
	EAttribute getIMarkupToFileBodyPartTemplate_InputFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate#getOutputFomat <em>Output Fomat</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Output Fomat</em>'.
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate#getOutputFomat()
	 * @see #getIMarkupToFileBodyPartTemplate()
	 * @generated
	 */
	EAttribute getIMarkupToFileBodyPartTemplate_OutputFomat();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	MarkupEMFDocumentStructureTemplateFactory getMarkupEMFDocumentStructureTemplateFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each operation of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.EAttributeInMarkupToFileImpl <em>EAttribute In Markup To File</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.EAttributeInMarkupToFileImpl
		 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.MarkupEMFDocumentStructureTemplatePackageImpl#getEAttributeInMarkupToFile()
		 * @generated
		 */
		EClass EATTRIBUTE_IN_MARKUP_TO_FILE = eINSTANCE.getEAttributeInMarkupToFile();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate <em>IMarkup To File Body Part Template</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate
		 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl.MarkupEMFDocumentStructureTemplatePackageImpl#getIMarkupToFileBodyPartTemplate()
		 * @generated
		 */
		EClass IMARKUP_TO_FILE_BODY_PART_TEMPLATE = eINSTANCE.getIMarkupToFileBodyPartTemplate();

		/**
		 * The meta object literal for the '<em><b>Input Format</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute IMARKUP_TO_FILE_BODY_PART_TEMPLATE__INPUT_FORMAT = eINSTANCE.getIMarkupToFileBodyPartTemplate_InputFormat();

		/**
		 * The meta object literal for the '<em><b>Output Fomat</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute IMARKUP_TO_FILE_BODY_PART_TEMPLATE__OUTPUT_FOMAT = eINSTANCE.getIMarkupToFileBodyPartTemplate_OutputFomat();

	}

} // MarkupEMFDocumentStructureTemplatePackage
