/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.editor;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.system.XSimpleMailClient;
import com.sun.star.system.XSimpleMailClientSupplier;
import com.sun.star.system.XSimpleMailMessage;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ooo.connector.BootstrapSocketConnector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.message.Messages;
import org.eclipse.papyrus.model2doc.odt.internal.util.LibreOfficeInstallationPathUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ODTEditor {
    public static final String LIBREOFFICE_FILE_PREFIX = "file:///";
    private static final String STANDART_FILE_PREFIX = "file:/";
    public static final String FILE_SEPARATOR = "/";
    private XComponentLoader officeLoader = null;
    private XTextDocument xTextDocument = null;
    private XDesktop xDesktop = null;
    private IDocumentGeneratorConfiguration configuration;
    private XMultiComponentFactory xMultiComponentFactory = null;
    private XMultiServiceFactory xMultiServiceFactory = null;
    private XComponentContext xComponentContext = null;
    private XDispatchHelper dispatchHelper = null;

    public ODTEditor() {
        this.loadOffice();
    }

    @Deprecated
    public ODTEditor(String projectFolder) {
        this();
    }

    public ODTEditor(IDocumentGeneratorConfiguration generatorConfig) {
        this.configuration = generatorConfig;
        this.loadOffice();
        if (this.officeLoader != null) {
            String templateURL = generatorConfig.createTemplateFileInputAccessor().createInputFileURL().toString();
            this.createTextDocument(templateURL);
            this.xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
            try {
                Object dispatchHelperObject = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.DispatchHelper", this.xComponentContext);
                this.dispatchHelper = (XDispatchHelper)UnoRuntime.queryInterface(XDispatchHelper.class, (Object)dispatchHelperObject);
            }
            catch (com.sun.star.uno.Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public XTextDocument getXTextDocument() {
        return this.xTextDocument;
    }

    public XMultiComponentFactory getXMultiComponentFactory() {
        return this.xMultiComponentFactory;
    }

    public XMultiServiceFactory getXMultiServiceFactory() {
        return this.xMultiServiceFactory;
    }

    public XComponentContext getXComponentContext() {
        return this.xComponentContext;
    }

    public XNameContainer getBitmapTable(String imagePath) {
        XNameContainer bitmapTable = null;
        try {
            bitmapTable = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)this.xMultiServiceFactory.createInstance("com.sun.star.drawing.BitmapTable"));
        }
        catch (com.sun.star.uno.Exception e) {
            Activator.log.error((Throwable)e);
        }
        if (bitmapTable != null && !bitmapTable.hasByName(imagePath)) {
            try {
                bitmapTable.insertByName(imagePath, (Object)imagePath);
            }
            catch (ElementExistException | IllegalArgumentException | WrappedTargetException e) {
                Activator.log.error(e);
            }
        }
        return bitmapTable;
    }

    public XPageCursor getPageCursor() {
        XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDocument);
        XController xController = model.getCurrentController();
        XTextViewCursorSupplier supplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
        return (XPageCursor)UnoRuntime.queryInterface(XPageCursor.class, (Object)supplier.getViewCursor());
    }

    public void openDocument(String documentURL) {
        XComponent xComponent = this.getDocument(documentURL);
        if (xComponent != null) {
            XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            XWindow xWindow = model.getCurrentController().getFrame().getContainerWindow();
            xWindow.setVisible(true);
            xWindow.setFocus();
        }
    }

    public String save(String fileName) {
        return this.saveAs(fileName, "odt");
    }

    public String saveAs(String fileName, String extension) {
        Assert.isLegal(("pdf" != extension ? 1 : 0) != 0);
        String exportedDocumentURL = this.saveDocument(fileName, extension);
        return exportedDocumentURL;
    }

    public String exportDocument(String inputFileURI, String outputFileURI, PropertyValue[] storeProperties) throws Exception {
        if (!(inputFileURI = ODTEditor.convertToLibreOfficeFileURI(inputFileURI)).startsWith(LIBREOFFICE_FILE_PREFIX)) {
            throw new Exception("The fileURI is not conform to the expected one");
        }
        if (!(outputFileURI = ODTEditor.convertToLibreOfficeFileURI(outputFileURI)).startsWith(LIBREOFFICE_FILE_PREFIX)) {
            throw new Exception("The fileURI is not conform to the expected one");
        }
        XComponent xComponent = this.getDocument(inputFileURI);
        if (xComponent != null) {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            XStorable store = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xTextDocument);
            try {
                store.storeToURL(outputFileURI, storeProperties);
            }
            catch (IOException e) {
                outputFileURI = null;
                Activator.log.error(String.valueOf(outputFileURI) + " have not been saved: ", (Throwable)e);
            }
        }
        this.closeDocument();
        this.closeLibreOffice();
        return outputFileURI;
    }

    public String saveAs(String inputFileURI, String outputFileURI, PropertyValue[] storeProperties) throws Exception {
        if (!(inputFileURI = ODTEditor.convertToLibreOfficeFileURI(inputFileURI)).startsWith(LIBREOFFICE_FILE_PREFIX)) {
            throw new Exception("The fileURI is not conform to the expected one");
        }
        if (!(outputFileURI = ODTEditor.convertToLibreOfficeFileURI(outputFileURI)).startsWith(LIBREOFFICE_FILE_PREFIX)) {
            throw new Exception("The fileURI is not conform to the expected one");
        }
        XComponent xComponent = this.getDocument(inputFileURI);
        if (xComponent != null) {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            XStorable store = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xTextDocument);
            try {
                store.storeAsURL(outputFileURI, storeProperties);
            }
            catch (IOException e) {
                outputFileURI = null;
                Activator.log.error(String.valueOf(outputFileURI) + " have not been saved: ", (Throwable)e);
            }
        }
        this.closeDocument();
        this.closeLibreOffice();
        return outputFileURI;
    }

    public String getFormat(String extension) {
        switch (extension) {
            case "odt": {
                return "writer8";
            }
            case "pdf": {
                return "writer_pdf_Export";
            }
        }
        return "writer8";
    }

    public void sendMail(String subject, String documentToAttach) {
        System.out.println("Subject: " + subject + " DocumentURL: " + documentToAttach);
        XSimpleMailClientSupplier xSimpleMailClientSupplier = this.createSimpleMailClientSupplier();
        if (xSimpleMailClientSupplier != null) {
            XSimpleMailClient xSimpleMailClient = xSimpleMailClientSupplier.querySimpleMailClient();
            XSimpleMailMessage mailMessage = xSimpleMailClient.createSimpleMailMessage();
            mailMessage.setSubject(subject);
            if (documentToAttach != null) {
                String[] attachs = new String[]{documentToAttach};
                mailMessage.setAttachement(attachs);
            }
            try {
                xSimpleMailClient.sendSimpleMailMessage(mailMessage, 0);
            }
            catch (IllegalArgumentException | com.sun.star.uno.Exception e) {
                Activator.log.error(e);
            }
        } else {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.ODTEditor_SendMail, (String)Messages.ODTEditor_MailClientWasNotFound);
        }
    }

    public void closeDocument(String documentURL) {
        XComponent xComponent = this.getDocument(documentURL);
        if (xComponent != null) {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            this.closeDocument();
            this.closeLibreOffice();
        }
    }

    public XComponent getDocument(String documentURL) {
        XComponent xComponent = null;
        if (this.officeLoader != null) {
            PropertyValue[] props = new PropertyValue[]{new PropertyValue()};
            props[0].Name = "Hidden";
            props[0].Value = true;
            try {
                Activator.log.debug(NLS.bind((String)"Loading the document from {0}", (Object)documentURL));
                xComponent = this.officeLoader.loadComponentFromURL(documentURL, "_blank", 0, props);
            }
            catch (IOException | IllegalArgumentException e) {
                Activator.log.error("Unable to get document object from" + documentURL + " : ", e);
            }
        }
        return xComponent;
    }

    private void loadOffice() {
        String oooExeFolder = LibreOfficeInstallationPathUtil.getLibreOfficeInstallationPath();
        if (oooExeFolder == null || oooExeFolder.isEmpty()) {
            Activator.log.warn("The path for the LibreOffice installation is null or empty. We stop the documentation generation.");
        }
        try {
            try {
                this.xComponentContext = BootstrapSocketConnector.bootstrap((String)oooExeFolder);
                this.xMultiComponentFactory = this.xComponentContext.getServiceManager();
                if (this.xMultiComponentFactory != null) {
                    Object oDesktop = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.xComponentContext);
                    this.xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)oDesktop);
                    this.officeLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.xDesktop);
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                if (this.officeLoader == null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ODTEditor_LibreOfficeDocumentGenerator_ErrorTitle, (String)Messages.ODTEditor_LibreOfficeDocumentGenerator_ErrorMessage);
                    LibreOfficeInstallationPathUtil.eraseLibreOfficeInstallationPath();
                }
            }
        }
        finally {
            if (this.officeLoader == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ODTEditor_LibreOfficeDocumentGenerator_ErrorTitle, (String)Messages.ODTEditor_LibreOfficeDocumentGenerator_ErrorMessage);
                LibreOfficeInstallationPathUtil.eraseLibreOfficeInstallationPath();
            }
        }
    }

    private XTextDocument createTextDocument(String templateURL) {
        try {
            XComponent xComponent = null;
            xComponent = templateURL != null && !templateURL.isEmpty() ? this.createNewDocumentFromTemplate(ODTEditor.convertToLibreOfficeFileURI(templateURL)) : this.createNewDocument();
            XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            XWindow xWindow = model.getCurrentController().getFrame().getContainerWindow();
            xWindow.setVisible(false);
            xWindow.setFocus();
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return this.xTextDocument;
    }

    private XComponent createNewDocument() {
        String sURL = "private:factory/swriter";
        XComponent xComponent = null;
        PropertyValue[] xEmptyArgs = new PropertyValue[]{};
        try {
            Activator.log.debug("Loading XComponent without Template.");
            xComponent = this.officeLoader.loadComponentFromURL(sURL, "_blank", 0, xEmptyArgs);
        }
        catch (Exception e) {
            Activator.log.error("We failed to load XComponent without template", (Throwable)e);
        }
        return xComponent;
    }

    private XComponent createNewDocumentFromTemplate(String templateURL) {
        XComponent xComponent = null;
        try {
            PropertyValue[] props = new PropertyValue[2];
            props[0] = new PropertyValue();
            props[0].Name = "Hidden";
            props[0].Value = true;
            props[1] = new PropertyValue();
            props[1].Name = "AsTemplate";
            props[1].Value = true;
            Activator.log.debug(NLS.bind((String)"Loading Component from Template {0}.", (Object)templateURL));
            xComponent = this.officeLoader.loadComponentFromURL(ODTEditor.convertToLibreOfficeFileURI(templateURL), "_blank", 0, props);
        }
        catch (Exception e) {
            Activator.log.error(NLS.bind((String)"We failed to load XComponent from the template {0}.", (Object)templateURL), (Throwable)e);
        }
        if (xComponent == null) {
            xComponent = this.createNewDocument();
        }
        return xComponent;
    }

    private XSimpleMailClientSupplier createSimpleMailClientSupplier() {
        XSimpleMailClientSupplier xSimpleMailClientSupplier = null;
        Object oSimpleMailClientSupplier = null;
        try {
            oSimpleMailClientSupplier = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.system.SimpleSystemMail", this.xComponentContext);
            if (oSimpleMailClientSupplier != null) {
                xSimpleMailClientSupplier = (XSimpleMailClientSupplier)UnoRuntime.queryInterface(XSimpleMailClientSupplier.class, (Object)oSimpleMailClientSupplier);
            } else {
                oSimpleMailClientSupplier = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.system.SimpleCommandMail", this.xComponentContext);
                if (oSimpleMailClientSupplier != null) {
                    xSimpleMailClientSupplier = (XSimpleMailClientSupplier)UnoRuntime.queryInterface(XSimpleMailClientSupplier.class, (Object)oSimpleMailClientSupplier);
                }
            }
        }
        catch (com.sun.star.uno.Exception e) {
            Activator.log.error((Throwable)e);
        }
        return xSimpleMailClientSupplier;
    }

    private String saveDocument(String fileName, String extension) {
        Assert.isLegal(("pdf" != extension ? 1 : 0) != 0);
        XStorable store = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xTextDocument);
        String saveFileURL = ODTEditor.convertToLibreOfficeFileURI(this.configuration.createDocumentOutputAccessor().createOutputFileURL(this.configuration.getDocumentName(), extension).toString());
        if (saveFileURL == null) {
            return null;
        }
        PropertyValue[] storeProps = new PropertyValue[2];
        storeProps[0] = new PropertyValue();
        storeProps[0].Name = "Overwrite";
        storeProps[0].Value = true;
        storeProps[1] = new PropertyValue();
        storeProps[1].Name = "FilterName";
        storeProps[1].Value = this.getFormat(extension);
        try {
            store.storeAsURL(saveFileURL, storeProps);
        }
        catch (IOException e) {
            saveFileURL = null;
            Activator.log.error(String.valueOf(saveFileURL) + " have not been saved: ", (Throwable)e);
        }
        this.closeDocument();
        this.closeLibreOffice();
        return saveFileURL;
    }

    private void closeDocument() {
        XCloseable closeable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDocument);
        if (closeable == null) {
            return;
        }
        try {
            closeable.close(false);
        }
        catch (DisposedException e) {
            Activator.log.warn("Document close failed since LibreOffice link disposed.");
        }
        catch (CloseVetoException e) {
            Activator.log.error("Close was vetoed: ", (Throwable)e);
        }
    }

    private void closeLibreOffice() {
        Activator.log.debug("I'm closing libreOffice");
        this.closeOfficeConnection();
        this.officeLoader = null;
        this.xTextDocument = null;
        this.xDesktop = null;
        this.officeLoader = null;
        this.xTextDocument = null;
        this.xDesktop = null;
        this.configuration = null;
        this.xMultiComponentFactory = null;
        this.xMultiServiceFactory = null;
        this.xComponentContext = null;
        this.dispatchHelper = null;
    }

    public static final String convertToLibreOfficeFileURI(String fileURI) {
        String newFileURI = fileURI;
        if (newFileURI.startsWith(STANDART_FILE_PREFIX) && !newFileURI.startsWith(LIBREOFFICE_FILE_PREFIX)) {
            newFileURI = newFileURI.replaceFirst(STANDART_FILE_PREFIX, LIBREOFFICE_FILE_PREFIX);
        } else if (newFileURI.startsWith(FILE_SEPARATOR)) {
            newFileURI = newFileURI.replaceFirst(FILE_SEPARATOR, LIBREOFFICE_FILE_PREFIX);
        }
        return newFileURI;
    }

    public static final String convertToGenericFileURI(String fileURI) {
        String newFileURI = fileURI;
        if (newFileURI.startsWith(LIBREOFFICE_FILE_PREFIX)) {
            newFileURI = newFileURI.replaceFirst(LIBREOFFICE_FILE_PREFIX, STANDART_FILE_PREFIX);
        }
        return newFileURI;
    }

    public final XDispatchHelper getDispatchHelper() {
        return this.dispatchHelper;
    }

    private void closeOfficeConnection() {
        try {
            XBridgeFactory bridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)Bootstrap.createSimpleServiceManager().createInstance("com.sun.star.bridge.BridgeFactory"));
            if (bridgeFactory != null) {
                XBridge[] xBridgeArray = bridgeFactory.getExistingBridges();
                int n = xBridgeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XBridge bridge = xBridgeArray[n2];
                    ((XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)bridge)).dispose();
                    ++n2;
                }
            }
        }
        catch (Throwable e) {
            Activator.log.error("Exception disposing office process connection bridge:", e);
        }
    }
}

