/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.target;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.papyrus.moka.debug.messages.DebugEventContextKind;
import org.eclipse.papyrus.moka.debug.messages.DebugRequest;
import org.eclipse.papyrus.moka.debug.messages.MessagesFactory;
import org.eclipse.papyrus.moka.debug.messages.ThreadRequest;
import org.eclipse.papyrus.moka.debug.target.DebugElementStatus;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineDebugTarget;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineDebugTargetClientListener;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineThread;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineDebugTarget;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineDebugTargetClient;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineThread;
import org.eclipse.papyrus.moka.kernel.SuspensionReasons;
import org.eclipse.papyrus.moka.kernel.service.ServiceMqttClient;

public class ExecutionEngineDebugTargetClient
extends ServiceMqttClient
implements IExecutionEngineDebugTargetClient {
    private ExecutionEngineDebugTargetClientListener clientListener;

    public ExecutionEngineDebugTargetClient(String serverURI, String clientID, IExecutionEngineDebugTarget target) {
        super(serverURI, clientID);
        this.clientListener = new ExecutionEngineDebugTargetClientListener(target);
    }

    public void run() {
        super.run();
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            try {
                ((MqttAsyncClient)this.client).subscribe("debug-service/engine", 1, (IMqttMessageListener)this.clientListener);
                ((MqttAsyncClient)this.client).subscribe("debug-service/thread", 1, (IMqttMessageListener)this.clientListener);
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            try {
                ((MqttAsyncClient)this.client).unsubscribe("debug-service/engine");
                ((MqttAsyncClient)this.client).unsubscribe("debug-service/thread");
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            super.terminate();
        }
    }

    @Override
    public boolean fireResumeEngineEvent() {
        boolean published = false;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage resumeEngine = new MqttMessage();
            DebugRequest request = MessagesFactory.eINSTANCE.createDebugRequest();
            request.setContextKind(DebugEventContextKind.ENGINE);
            request.setEventKind(1);
            request.setEventDetail(32);
            resumeEngine.setPayload(request.toJson().getBytes());
            resumeEngine.setQos(1);
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-target/engine", resumeEngine);
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                published = token.isComplete();
            }
        }
        return published;
    }

    @Override
    public boolean fireSuspendEngineEvent() {
        boolean published = false;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage suspendEngine = new MqttMessage();
            DebugRequest request = MessagesFactory.eINSTANCE.createDebugRequest();
            request.setContextKind(DebugEventContextKind.ENGINE);
            request.setEventKind(2);
            request.setEventDetail(32);
            suspendEngine.setPayload(request.toJson().getBytes());
            suspendEngine.setQos(1);
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-target/engine", suspendEngine);
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                published = token.isComplete();
            }
        }
        return published;
    }

    @Override
    public boolean fireSuspendThreadEvent(IExecutionEngineThread thread) {
        boolean published = false;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage suspendEngineThread = new MqttMessage();
            ThreadRequest request = MessagesFactory.eINSTANCE.createThreadRequest();
            request.setContextKind(DebugEventContextKind.THREAD);
            request.setEventKind(2);
            request.setEventDetail(32);
            request.setThreadId(thread.getID());
            request.setSuspensionReason(SuspensionReasons.USER_ACTION);
            suspendEngineThread.setPayload(request.toJson().getBytes());
            suspendEngineThread.setQos(1);
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-target/thread", suspendEngineThread, thread, new SuspendThreadActionListener());
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                published = token.isComplete();
            }
        }
        return published;
    }

    @Override
    public boolean fireResumeThreadEvent(IExecutionEngineThread thread) {
        boolean published = false;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage resumedEngineThread = new MqttMessage();
            ThreadRequest request = MessagesFactory.eINSTANCE.createThreadRequest();
            request.setContextKind(DebugEventContextKind.THREAD);
            request.setEventKind(1);
            request.setEventDetail(32);
            request.setThreadId(thread.getID());
            request.setSuspensionReason(SuspensionReasons.NONE);
            resumedEngineThread.setPayload(request.toJson().getBytes());
            resumedEngineThread.setQos(1);
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-target/thread", resumedEngineThread, thread, new ResumeThreadActionListener());
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                published = token.isComplete();
            }
        }
        return published;
    }

    @Override
    public boolean fireTerminateThreadEvent(IExecutionEngineThread thread) {
        boolean published = false;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage resumedEngineThread = new MqttMessage();
            ThreadRequest request = MessagesFactory.eINSTANCE.createThreadRequest();
            request.setContextKind(DebugEventContextKind.THREAD);
            request.setEventKind(8);
            request.setEventDetail(32);
            request.setThreadId(thread.getID());
            resumedEngineThread.setPayload(request.toJson().getBytes());
            resumedEngineThread.setQos(1);
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-target/thread", resumedEngineThread, thread, new TerminateThreadActionListener());
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                published = token.isComplete();
            }
        }
        return published;
    }

    class ResumeThreadActionListener
    implements IMqttActionListener {
        ResumeThreadActionListener() {
        }

        public void onFailure(IMqttToken token, Throwable exception) {
            ExecutionEngineThread thread = (ExecutionEngineThread)token.getUserContext();
            if (thread != null) {
                thread.setStatus(DebugElementStatus.SUSPENDED);
            }
        }

        public void onSuccess(IMqttToken token) {
            ExecutionEngineThread thread = (ExecutionEngineThread)token.getUserContext();
            thread.setStatus(DebugElementStatus.RUNNING);
            thread.fireResumeEvent(32);
            ExecutionEngineDebugTarget target = (ExecutionEngineDebugTarget)thread.getDebugTarget();
            target.fireChangeEvent(256);
        }
    }

    class SuspendThreadActionListener
    implements IMqttActionListener {
        SuspendThreadActionListener() {
        }

        public void onFailure(IMqttToken token, Throwable exception) {
            ExecutionEngineThread thread = (ExecutionEngineThread)token.getUserContext();
            if (thread != null) {
                thread.setStatus(DebugElementStatus.RUNNING);
            }
        }

        public void onSuccess(IMqttToken token) {
            ExecutionEngineThread thread = (ExecutionEngineThread)token.getUserContext();
            if (thread != null) {
                thread.fireSuspendEvent(32);
                ExecutionEngineDebugTarget target = (ExecutionEngineDebugTarget)thread.getDebugTarget();
                target.fireChangeEvent(256);
            }
        }
    }

    class TerminateThreadActionListener
    implements IMqttActionListener {
        TerminateThreadActionListener() {
        }

        public void onFailure(IMqttToken token, Throwable exception) {
            ExecutionEngineThread thread = (ExecutionEngineThread)token.getUserContext();
            if (thread != null) {
                thread.setStatus(DebugElementStatus.RUNNING);
            }
        }

        public void onSuccess(IMqttToken token) {
            ExecutionEngineThread thread = (ExecutionEngineThread)token.getUserContext();
            thread.setStatus(DebugElementStatus.TERMINATED);
            thread.fireTerminateEvent();
            ExecutionEngineDebugTarget target = (ExecutionEngineDebugTarget)thread.getDebugTarget();
            target.fireChangeEvent(256);
        }
    }
}

