/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.decorators;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CDOStateAdapter
extends AdapterImpl {
    private DawnState state = DawnState.CLEAN;

    CDOStateAdapter() {
    }

    public static CDOStateAdapter require(Notifier notifier) {
        CDOStateAdapter result = CDOStateAdapter.get(notifier);
        if (result == null) {
            result = new CDOStateAdapter();
            notifier.eAdapters().add((Object)result);
        }
        return result;
    }

    public static CDOStateAdapter get(Notifier notifier) {
        return (CDOStateAdapter)EcoreUtil.getExistingAdapter((Notifier)notifier, DawnState.class);
    }

    public static DawnState getState(Notifier notifier) {
        CDOStateAdapter adapter = CDOStateAdapter.get(notifier);
        return adapter == null ? DawnState.CLEAN : adapter.getState();
    }

    public static void setState(Notifier notifier, DawnState state) {
        if (state == DawnState.CLEAN) {
            CDOStateAdapter adapter = CDOStateAdapter.get(notifier);
            if (adapter != null) {
                notifier.eAdapters().remove((Object)adapter);
            }
        } else {
            CDOStateAdapter.require(notifier).setState(state);
        }
    }

    public static Iterable<CDOStateAdapter> getAll(ResourceSet resourceSet) {
        Tracker tracker = Tracker.get(resourceSet);
        Iterable<Object> result = tracker == null ? Collections.emptySet() : tracker.getStateAdapters();
        return result;
    }

    public boolean isAdapterForType(Object type) {
        return type == DawnState.class;
    }

    public DawnState getState() {
        return this.state;
    }

    public void setState(DawnState state) {
        this.state = state == null ? DawnState.CLEAN : state;
    }

    public void setTarget(Notifier newTarget) {
        ResourceSet rset;
        Resource res;
        super.setTarget(newTarget);
        if (newTarget instanceof EObject && (res = ((EObject)newTarget).eResource()) != null && (rset = res.getResourceSet()) != null) {
            Tracker.require(rset).add(this);
        }
    }

    public void unsetTarget(Notifier oldTarget) {
        Tracker tracker;
        ResourceSet rset;
        Resource res;
        if (oldTarget instanceof EObject && (res = ((EObject)oldTarget).eResource()) != null && (rset = res.getResourceSet()) != null && (tracker = Tracker.get(rset)) != null) {
            tracker.remove(this);
        }
        super.unsetTarget(oldTarget);
    }

    private static final class Tracker
    extends AdapterImpl {
        private final Set<CDOStateAdapter> stateAdapters = Sets.newHashSet();

        private Tracker() {
        }

        static Tracker get(ResourceSet resourceSet) {
            Tracker result = null;
            for (Object next : resourceSet.eAdapters()) {
                if (!(next instanceof Tracker)) continue;
                result = (Tracker)((Object)next);
                break;
            }
            return result;
        }

        static Tracker require(ResourceSet resourceSet) {
            Tracker result = Tracker.get(resourceSet);
            if (result == null) {
                result = new Tracker();
                resourceSet.eAdapters().add((Object)result);
            }
            return result;
        }

        void add(CDOStateAdapter stateAdapter) {
            this.stateAdapters.add(stateAdapter);
        }

        void remove(CDOStateAdapter stateAdapter) {
            this.stateAdapters.remove((Object)stateAdapter);
        }

        Iterable<CDOStateAdapter> getStateAdapters() {
            return this.stateAdapters;
        }
    }
}

