/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.decorators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.appearance.DawnElementStylizer;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.swt.graphics.Image;

public class CDOStateDiagramDecorator
extends AbstractDecorator {
    private DawnElementStylizer stylizer;

    public CDOStateDiagramDecorator(IDecoratorTarget decoratorTarget, DawnElementStylizer stylizer) {
        super(decoratorTarget);
        this.stylizer = stylizer;
    }

    public void activate() {
    }

    public void refresh() {
        CDOObject cdo;
        this.removeDecoration();
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        EObject element = view == null || !view.isSetElement() ? null : view.getElement();
        CDOObject cDOObject = cdo = element == null ? null : CDOUtils.getCDOObject((EObject)element);
        if (cdo != null) {
            Image image;
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            DawnState state = CDOStateAdapter.getState((Notifier)view);
            if (state == DawnState.CLEAN) {
                state = CDOStateAdapter.getState((Notifier)element);
            }
            if ((image = this.stylizer.getImage((Object)editPart, state)) != null) {
                if (editPart instanceof ShapeEditPart) {
                    int margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(-1);
                    this.setDecoration(this.getDecoratorTarget().addShapeDecoration(image, IDecoratorTarget.Direction.SOUTH_EAST, margin, true));
                } else if (view instanceof Edge) {
                    int percent = 50;
                    this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(image, percent, true));
                }
            }
        }
    }
}

