/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.decorators;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.dawn.appearance.DawnElementStylizer;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.dawn.ui.stylizer.DawnElementStylizerRegistry;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.ui.Activator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.UIJob;

public class CDOStateLabelDecorator
implements ILabelDecorator {
    private static Set<CDOStateLabelDecorator> instances = new CopyOnWriteArraySet<CDOStateLabelDecorator>();
    private final ResourceManager manager = new LocalResourceManager(JFaceResources.getResources());
    private final ListenerList listeners = new ListenerList();
    private static LabelUpdateJob labelUpdateJob = new LabelUpdateJob();

    public CDOStateLabelDecorator() {
        instances.add(this);
    }

    public void dispose() {
        this.manager.dispose();
        instances.remove(this);
    }

    public Image decorateImage(Image image, Object element) {
        ImageDescriptor decoration;
        DawnElementStylizer stylizer;
        DawnState state;
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && (state = CDOStateAdapter.getState((Notifier)eObject)) != DawnState.CLEAN && (stylizer = DawnElementStylizerRegistry.instance.getStylizer((Object)eObject)) != null && (decoration = ImageDescriptor.createFromImage((Image)stylizer.getImage((Object)eObject, state))) != null) {
            DecorationOverlayIcon desc = new DecorationOverlayIcon(image, decoration, 3);
            return (Image)this.manager.get((DeviceResourceDescriptor)desc);
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public static void fireLabelUpdates() {
        labelUpdateJob.poke();
    }

    private void fireUpdates() {
        Object[] listeners = this.listeners.getListeners();
        if (listeners.length > 0) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in label provider listener.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    private static class LabelUpdateJob
    extends UIJob {
        private final Object lock = new Object();
        private boolean pending;

        LabelUpdateJob() {
            super(Messages.CDOStateLabelDecorator_1);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    this.pending = false;
                }
                for (CDOStateLabelDecorator next : instances) {
                    next.fireUpdates();
                }
                object = this.lock;
                synchronized (object) {
                    if (!this.pending) {
                        break;
                    }
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void poke() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.pending) {
                    this.pending = true;
                    if (this.getState() != 4) {
                        this.schedule();
                    }
                }
            }
        }
    }
}

