/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.decorators;

import org.eclipse.emf.cdo.dawn.gmf.appearance.DawnEditPartStylizer;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.papyrus.cdo.ui.SharedImages;
import org.eclipse.swt.graphics.Image;

abstract class PapyrusEditPartStylizer
extends DawnEditPartStylizer {
    public Image getImage(Object element, DawnState state) {
        return switch (state) {
            case DawnState.LOCKED_LOCALLY -> SharedImages.getImage("self_locked_ovr24");
            case DawnState.LOCKED_REMOTELY -> SharedImages.getImage("other_locked_ovr24");
            case DawnState.CONFLICT -> SharedImages.getImage("conflicted_ovr24");
            default -> super.getImage(element, state);
        };
    }

    public void setDefault(EditPart editPart) {
        this.setState(editPart, DawnState.CLEAN);
    }

    public void setLocked(EditPart editPart, int type) {
        this.setState(editPart, switch (type) {
            case 4 -> DawnState.LOCKED_REMOTELY;
            case 3 -> DawnState.LOCKED_LOCALLY;
            default -> DawnState.LOCKED_REMOTELY;
        });
    }

    public void setConflicted(EditPart editPart, int type) {
        this.setState(editPart, DawnState.CONFLICT);
    }

    protected void setState(final EditPart editPart, DawnState state) {
        View view = (View)editPart.getModel();
        CDOStateAdapter.setState((Notifier)view, state);
        DisplayUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                editPart.refresh();
            }
        });
    }
}

