/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.editors;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.papyrus.cdo.ui.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class DawnEditorAdapter
implements IDawnEditor {
    private static Map<IEditorPart, IDawnEditor> ADAPTERS = Maps.newHashMap();
    private final DiagramDocumentEditor diagramEditor;
    private IDawnEditorSupport editorSupport;
    private CDOView view;
    private String contributorID;

    public DawnEditorAdapter(DiagramDocumentEditor diagramEditor) {
        this.diagramEditor = diagramEditor;
        ADAPTERS.put((IEditorPart)diagramEditor, this);
    }

    DiagramDocumentEditor getDiagramEditor() {
        return this.diagramEditor;
    }

    public static IDawnEditor getDawnEditor(IEditorPart editor) {
        return ADAPTERS.get(editor);
    }

    static void removeAdapter(IEditorPart editor) {
        ADAPTERS.remove(editor);
    }

    public CDOView getView() {
        return this.view;
    }

    void setView(CDOView view) {
        this.view = view;
    }

    public String getContributorID() {
        if (this.contributorID == null) {
            this.contributorID = this.determineEditorID(this.diagramEditor);
        }
        return this.contributorID;
    }

    public void setDirty() {
        IDocumentProvider documentProvider = this.diagramEditor.getDocumentProvider();
        if (documentProvider != null) {
            documentProvider.setCanSaveDocument((Object)this.getEditorInput());
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == DiagramDocumentEditor.class || adapter == DiagramEditor.class) {
            return this.diagramEditor;
        }
        return this.diagramEditor.getAdapter(adapter);
    }

    private String determineEditorID(DiagramDocumentEditor editor) {
        String result = null;
        Class<?> clazz = editor.getClass();
        while (clazz != null && clazz != Object.class) {
            try {
                Field idField = clazz.getField("ID");
                int modifiers = idField.getModifiers();
                if (idField.getType() == String.class && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers)) {
                    result = (String)idField.get(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        if (result == null) {
            result = String.valueOf(editor.getClass().getName()) + "ID";
        }
        return result;
    }

    public void doSave(IProgressMonitor monitor) {
        CDOView view = this.getView();
        if (view instanceof CDOTransaction) {
            try {
                ((CDOTransaction)view).commit(monitor);
            }
            catch (CommitException e) {
                Activator.log.error("Failed to commit transaction to save editor.", (Throwable)e);
            }
        } else {
            this.diagramEditor.doSave(monitor);
        }
    }

    public boolean isDirty() {
        return this.diagramEditor.isDirty();
    }

    public IDawnEditorSupport getDawnEditorSupport() {
        return this.editorSupport;
    }

    void setEditorSupport(IDawnEditorSupport editorSupport) {
        this.editorSupport = editorSupport;
    }

    public IEditorInput getEditorInput() {
        return this.diagramEditor.getEditorInput();
    }

    public IEditorSite getEditorSite() {
        return this.diagramEditor.getEditorSite();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.diagramEditor.init(site, input);
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.diagramEditor.addPropertyListener(listener);
    }

    public void createPartControl(Composite parent) {
        this.diagramEditor.createPartControl(parent);
    }

    public void dispose() {
        this.diagramEditor.dispose();
    }

    public IWorkbenchPartSite getSite() {
        return this.diagramEditor.getSite();
    }

    public String getTitle() {
        return this.diagramEditor.getTitle();
    }

    public Image getTitleImage() {
        return this.diagramEditor.getTitleImage();
    }

    public String getTitleToolTip() {
        return this.diagramEditor.getTitleToolTip();
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.diagramEditor.removePropertyListener(listener);
    }

    public void setFocus() {
        this.diagramEditor.setFocus();
    }

    public void doSaveAs() {
        this.diagramEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.diagramEditor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.diagramEditor.isSaveOnCloseNeeded();
    }
}

