/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.expressions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;

public class CDOObjectPropertyTester
extends PropertyTester {
    public static final String CAN_LOCK = "canLock";
    public static final String IS_LOCKED_LOCALLY = "isLockedLocally";
    public static final String IS_LOCKED_REMOTELY = "isLockedRemotely";
    public static final String IS_CONFLICTED = "isConflicted";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        CDOObject cdoObject = (CDOObject)receiver;
        if (cdoObject != null) {
            if (CAN_LOCK.equals(property)) {
                result = this.canLock(cdoObject);
            } else if (IS_LOCKED_LOCALLY.equals(property)) {
                result = this.isLockedLocally(cdoObject);
            } else if (IS_LOCKED_REMOTELY.equals(property)) {
                result = this.isLockedRemotely(cdoObject);
            } else if (IS_CONFLICTED.equals(property)) {
                result = this.isConflicted(cdoObject);
            }
        }
        return result;
    }

    private boolean canLock(CDOObject object) {
        boolean result = CDOUtils.isLockable((CDOObject)object);
        if (result) {
            DawnState state = CDOStateAdapter.getState((Notifier)object);
            result = state != DawnState.LOCKED_LOCALLY && state != DawnState.LOCKED_REMOTELY;
        }
        return result;
    }

    private boolean isLockedLocally(CDOObject object) {
        return CDOStateAdapter.getState((Notifier)object) == DawnState.LOCKED_LOCALLY;
    }

    private boolean isLockedRemotely(CDOObject object) {
        return CDOStateAdapter.getState((Notifier)object) == DawnState.LOCKED_REMOTELY;
    }

    private boolean isConflicted(CDOObject object) {
        return CDOStateAdapter.getState((Notifier)object) == DawnState.CONFLICT;
    }
}

