/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.views;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.cdo.internal.ui.views.DIResourceQuery;
import org.eclipse.papyrus.cdo.internal.ui.views.ItemProviderFilterRegistry;
import org.eclipse.papyrus.cdo.ui.SharedImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

public class CheckoutItemProvider
extends CDOItemProvider {
    private final Predicate<Object> isDIResource = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof CDOResource && DIResourceQuery.getDIResources(((CDOResource)input).cdoView()).contains(input);
        }
    };
    private final Predicate<Object> isUnaffiliatedResource = new Predicate<Object>(){

        public boolean apply(Object input) {
            return !(input instanceof CDOResource) || DIResourceQuery.isUnaffiliatedResource((CDOResource)input);
        }
    };
    private final Predicate<Object> resourceFilter = Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(CDOResourceFolder.class), this.isDIResource, this.isUnaffiliatedResource});
    private final Function<Object, Object> resourceNodeTransformer = new Function<Object, Object>(){

        public Object apply(Object input) {
            if (CheckoutItemProvider.this.isDIResource.apply(input)) {
                return DIModel.getInstance((CDOResource)input, true);
            }
            return input;
        }
    };
    private final Predicate<Object> extensibleFilter = ItemProviderFilterRegistry.INSTANCE.createFilter((ILabelProvider)this);

    public CheckoutItemProvider(IWorkbenchPage page, IElementFilter rootElementFilter) {
        super(page, rootElementFilter);
    }

    public CheckoutItemProvider(IWorkbenchPage page, Object rootElementToShow) {
        this(page, Collections.singleton(rootElementToShow));
    }

    public CheckoutItemProvider(IWorkbenchPage page, final Collection<?> rootElementsToShow) {
        this(page, new IElementFilter(){

            public boolean filter(Object element) {
                return rootElementsToShow.contains(element);
            }
        });
    }

    public CheckoutItemProvider(IWorkbenchPage page) {
        this(page, (IElementFilter)null);
    }

    public Object[] getChildren(Object element) {
        Iterable<Object> result;
        CDOCheckout checkout;
        if (element instanceof CDOCheckout && (checkout = (CDOCheckout)element).isOpen()) {
            DIResourceQuery.initialize(this.getViewer(), checkout.getView());
        }
        if (element instanceof DIModel) {
            result = Arrays.asList(((DIModel)((Object)element)).getChildren());
        } else {
            result = Arrays.asList(super.getChildren(element));
            if (element instanceof CDOResourceFolder || element instanceof CDOCheckout) {
                result = this.filterDIResources(result);
            }
        }
        return Iterables.toArray((Iterable)Iterables.filter(result, this.extensibleFilter), Object.class);
    }

    public Object getParent(Object element) {
        Object result;
        if (element instanceof CDOResource) {
            CDOResource di = DIResourceQuery.getAffiliateResource((CDOResource)element);
            result = di != null ? DIModel.getInstance(di, true) : super.getParent(element);
        } else if (element instanceof DIModel) {
            CDOResource resource = ((DIModel)((Object)element)).getResource();
            CDOView view = resource.cdoView();
            result = view != null && view.isClosed() ? null : super.getParent((Object)resource);
        } else {
            CDOView view = null;
            if (element instanceof CDOObject) {
                view = ((CDOObject)element).cdoView();
            }
            DIModel dIModel = result = view != null && view.isClosed() ? null : super.getParent(element);
            if (result instanceof CDOView) {
                result = CDOExplorerUtil.getCheckout((Object)((CDOView)result));
            }
        }
        return result;
    }

    protected Iterable<?> filter(Iterable<?> elements, Predicate<Object> predicate) {
        return Iterables.transform((Iterable)Iterables.filter(elements, predicate), this.resourceNodeTransformer);
    }

    protected Iterable<?> filterDIResources(Iterable<?> elements) {
        return this.filter(elements, this.resourceFilter);
    }

    public Image getImage(Object obj) {
        boolean open;
        Image result = obj instanceof CDOCheckout ? SharedImages.getImage((open = ((CDOCheckout)obj).isOffline()) ? "open_repository" : "closed_repository") : (obj instanceof DIModel ? ((DIModel)((Object)obj)).getImage() : super.getImage(obj));
        return result;
    }

    public String getText(Object obj) {
        String result = obj instanceof CDOCheckout ? ((CDOCheckout)obj).getLabel() : (obj instanceof DIModel ? ((DIModel)((Object)obj)).getName() : super.getText(obj));
        return result;
    }
}

