/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.views;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.papyrus.cdo.core.util.JobWaiter;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.ui.Activator;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;

public class DIResourceQuery {
    private static final Map<CDOView, DIResourceQuery> instances = Maps.newHashMap();
    private final StructuredViewer viewer;
    private final CDOQuery legacyQuery;
    private final CDOQuery query;
    private final Job queryJob = new QueryJob();
    private final IListener cdoViewListener = this.createCDOViewListener();
    private AtomicReference<Set<CDOResource>> diResources = new AtomicReference(Collections.emptySet());
    private Boolean hasLegacyModels;

    private DIResourceQuery(StructuredViewer viewer, CDOView view) {
        this.viewer = viewer;
        this.legacyQuery = view.createQuery("ocl", "SashWindowsMngr.allInstances()->collect(oclAsType(ecore::EObject).eResource()).oclAsType(eresource::CDOResource)->union(eresource::CDOResource.allInstances()->select(uRI.toString().endsWith('.di') and contents->exists(oclIsTypeOf(architecture::ArchitectureDescription)))", (Object)DiPackage.Literals.SASH_MODEL);
        this.query = view.createQuery("ocl", "eresource::CDOResource.allInstances()->select(uRI.toString().endsWith('.di') and contents->exists(oclIsTypeOf(architecture::ArchitectureDescription)))", (Object)EresourcePackage.Literals.CDO_RESOURCE);
        view.addListener(this.cdoViewListener);
        if (viewer != null) {
            viewer.getControl().addDisposeListener(this.createViewerDisposeListener());
        }
        this.runQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DIResourceQuery initialize(StructuredViewer viewer, CDOView view) {
        DIResourceQuery result;
        Map<CDOView, DIResourceQuery> map = instances;
        synchronized (map) {
            result = instances.get(view);
            if (result == null) {
                result = new DIResourceQuery(viewer, view);
                instances.put(view, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFor(CDOView view, long timeout, TimeUnit unit) throws InterruptedException {
        DIResourceQuery query;
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Non-positive timeout");
        }
        Map<CDOView, DIResourceQuery> map = instances;
        synchronized (map) {
            query = instances.get(view);
        }
        boolean result = query == null ? true : JobWaiter.waitFor((Object)query, (long)timeout, (TimeUnit)unit);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<CDOResource> getDIResources(CDOView view) {
        DIResourceQuery query;
        Map<CDOView, DIResourceQuery> map = instances;
        synchronized (map) {
            query = instances.get(view);
        }
        Set<Object> result = query == null ? Collections.emptySet() : query.getDIResources();
        return result;
    }

    public static boolean isUnaffiliatedResource(CDOResource resource) {
        return DIResourceQuery.getAffiliateResource(resource) == null;
    }

    public static CDOResource getAffiliateResource(CDOResource resource) {
        CDOResource result = null;
        URI uri = resource.getURI();
        if ("di".equals(uri.fileExtension())) {
            result = resource;
        } else {
            uri = uri.trimFileExtension().appendFileExtension("di");
            for (CDOResource next : DIResourceQuery.getDIResources(resource.cdoView())) {
                if (!uri.equals(next.getURI())) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    public Set<CDOResource> getDIResources() {
        return this.diResources.get();
    }

    boolean hasLegacyModels() {
        if (this.hasLegacyModels == null) {
            this.hasLegacyModels = this.query.getView().getSession().getPackageRegistry().getPackageInfo((EPackage)DiPackage.eINSTANCE) != null;
        }
        return this.hasLegacyModels;
    }

    private void runQuery() {
        this.queryJob.schedule();
    }

    void refresh() {
        this.viewer.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        Map<CDOView, DIResourceQuery> map = instances;
        synchronized (map) {
            CDOView view = this.query.getView();
            view.removeListener(this.cdoViewListener);
            instances.remove(view);
        }
    }

    private IListener createCDOViewListener() {
        return new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof ILifecycleEvent) {
                    ILifecycleEvent lifecycleEvent = (ILifecycleEvent)event;
                    if (lifecycleEvent.getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                        DIResourceQuery.this.dispose();
                    }
                } else if (event instanceof CDOViewInvalidationEvent) {
                    DIResourceQuery.this.runQuery();
                }
            }
        };
    }

    private DisposeListener createViewerDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DIResourceQuery.this.dispose();
            }
        };
    }

    private class QueryJob
    extends Job {
        QueryJob() {
            super(Messages.DIResourceQuery_2);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == DIResourceQuery.this;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display display;
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            List rawResult = DIResourceQuery.this.hasLegacyModels() ? DIResourceQuery.this.legacyQuery.getResult(CDOResource.class) : DIResourceQuery.this.query.getResult(CDOResource.class);
            int i = 0;
            while (i < rawResult.size()) {
                try {
                    CDOResource next = (CDOResource)rawResult.get(i);
                    if (this.isContained(next)) {
                        resultBuilder.add((Object)next);
                    }
                }
                catch (Exception e) {
                    Activator.log.error("Error retrieving resource result from CDO query.", (Throwable)e);
                }
                ++i;
            }
            ImmutableSet result = resultBuilder.build();
            DIResourceQuery.this.diResources.set((Set<CDOResource>)ImmutableSet.copyOf((Collection)result));
            if (DIResourceQuery.this.viewer != null && DIResourceQuery.this.viewer.getControl() != null && (display = DIResourceQuery.this.viewer.getControl().getDisplay()) != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (((QueryJob)QueryJob.this).DIResourceQuery.this.viewer != null && ((QueryJob)QueryJob.this).DIResourceQuery.this.viewer.getControl() != null && !((QueryJob)QueryJob.this).DIResourceQuery.this.viewer.getControl().isDisposed()) {
                            DIResourceQuery.this.refresh();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }

        private boolean isContained(CDOResource resource) {
            boolean result = false;
            CDOResourceFolder folder = resource.getFolder();
            if (folder != null) {
                if (folder.cdoPermission().isReadable()) {
                    result = folder.getNodes().contains((Object)resource);
                }
            } else {
                CDOResource root = resource.cdoResource();
                if (root != null && root.isRoot()) {
                    result = root.getContents().contains((Object)resource);
                }
            }
            return result;
        }
    }
}

