/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.widgets;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class ActionButton {
    private final SelectionWrapper selection;
    private final IAction action;
    private final String label;
    private final int style;
    private Button button;
    private List<StructuredViewer> dependentViewers;
    private ISelectionChangedListener selectionListener;

    public ActionButton(String label, BaseSelectionListenerAction action, int style) {
        this(label, (IAction)action, new DefaultSelectionAdapter(action), style);
    }

    public ActionButton(String label, IAction action, ISelectionAdapter selectionAdapter, int style) {
        this.selection = new SelectionWrapper(selectionAdapter);
        this.action = action;
        this.label = label;
        this.style = style;
    }

    public Button createControl(Composite parent) {
        this.button = new Button(parent, this.style);
        this.button.setText(this.label);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionButton.this.action.run();
                ActionButton.this.refreshViewers(ActionButton.this.selection.getSelection());
            }
        });
        this.button.setEnabled(this.action.isEnabled());
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ActionButton.this.dispose();
            }
        });
        return this.button;
    }

    public void attach(StructuredViewer viewer) {
        if (this.dependentViewers == null) {
            this.dependentViewers = Lists.newArrayListWithExpectedSize((int)1);
            this.dependentViewers.add(viewer);
            viewer.addSelectionChangedListener(this.getSelectionListener());
        } else if (!this.dependentViewers.contains(viewer)) {
            this.dependentViewers.add(viewer);
            viewer.addSelectionChangedListener(this.getSelectionListener());
        }
    }

    private void refreshViewers(IStructuredSelection objectsToUpdate) {
        if (this.dependentViewers != null) {
            for (StructuredViewer next : this.dependentViewers) {
                Iterator iter = objectsToUpdate.iterator();
                while (iter.hasNext()) {
                    next.refresh(iter.next());
                }
            }
        }
    }

    private ISelectionChangedListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ActionButton.this.selection.selectionChanged((IStructuredSelection)event.getSelection());
                    if (ActionButton.this.button != null) {
                        ActionButton.this.button.setEnabled(ActionButton.this.action.isEnabled());
                    }
                }
            };
        }
        return this.selectionListener;
    }

    private void dispose() {
        if (this.dependentViewers != null && this.selectionListener != null) {
            for (StructuredViewer next : this.dependentViewers) {
                next.removeSelectionChangedListener(this.selectionListener);
            }
        }
        this.dependentViewers = null;
        this.selectionListener = null;
    }

    private static final class DefaultSelectionAdapter
    implements ISelectionAdapter {
        private final BaseSelectionListenerAction action;

        DefaultSelectionAdapter(BaseSelectionListenerAction action) {
            this.action = action;
        }

        @Override
        public void selectionChanged(IStructuredSelection selection) {
            this.action.selectionChanged(selection);
        }
    }

    public static interface ISelectionAdapter {
        public void selectionChanged(IStructuredSelection var1);
    }

    private static final class SelectionWrapper
    implements ISelectionAdapter {
        private final ISelectionAdapter adapter;
        private IStructuredSelection selection;

        SelectionWrapper(ISelectionAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public void selectionChanged(IStructuredSelection selection) {
            this.selection = selection;
            this.adapter.selectionChanged(selection);
        }

        IStructuredSelection getSelection() {
            return this.selection;
        }
    }
}

