/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 212765, 418466, 451350, 485756
 *   Eike Stepper - 540786
 *   Kenn Hussey - 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectableElementTemplateParameter;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Connectable Element Template Parameter</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.ConnectableElementTemplateParameterImpl#getParameteredElement <em>Parametered Element</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConnectableElementTemplateParameterImpl
		extends TemplateParameterImpl
		implements ConnectableElementTemplateParameter {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectableElementTemplateParameterImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ParameterableElement getParameteredElement() {
		return (ParameterableElement) eDynamicGet(UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.TEMPLATE_PARAMETER__PARAMETERED_ELEMENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ParameterableElement basicGetParameteredElement() {
		return (ParameterableElement) eDynamicGet(UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.TEMPLATE_PARAMETER__PARAMETERED_ELEMENT, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParameteredElementGen(
			ParameterableElement newParameteredElement,
			NotificationChain msgs) {
		if (newParameteredElement != null && !(newParameteredElement instanceof ConnectableElement)) {
			throw new IllegalArgumentException("newParameteredElement must be an instance of ConnectableElement"); //$NON-NLS-1$
		}
		msgs = eDynamicInverseAdd((InternalEObject) newParameteredElement, UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT, msgs);
		return msgs;
	}

	@Override
	public NotificationChain basicSetParameteredElement(
			ParameterableElement newParameteredElement,
			NotificationChain msgs) {
		msgs = basicSetParameteredElementGen(newParameteredElement, msgs);

		Resource.Internal eInternalResource = eInternalResource();

		if (eInternalResource == null || !eInternalResource.isLoading()) {

			ParameterableElement ownedParameteredElement = basicGetOwnedParameteredElement();
			if (ownedParameteredElement != null
					&& ownedParameteredElement != newParameteredElement) {

				setOwnedParameteredElement(null);
			}
		}

		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParameteredElement(
			ParameterableElement newParameteredElement) {
		if (newParameteredElement != null && !(newParameteredElement instanceof ConnectableElement)) {
			throw new IllegalArgumentException("newParameteredElement must be an instance of ConnectableElement"); //$NON-NLS-1$
		}
		eDynamicSet(UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.TEMPLATE_PARAMETER__PARAMETERED_ELEMENT, newParameteredElement);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetParameteredElement() {
		return basicGetParameteredElement() != null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__EANNOTATIONS:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getEAnnotations()).basicAdd(otherEnd, msgs);
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT:
			ParameterableElement parameteredElement = basicGetParameteredElement();
			if (parameteredElement != null)
				msgs = ((InternalEObject) parameteredElement).eInverseRemove(this, UMLPackage.PARAMETERABLE_ELEMENT__TEMPLATE_PARAMETER, ParameterableElement.class, msgs);
			return basicSetParameteredElement((ParameterableElement) otherEnd, msgs);
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__SIGNATURE:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetSignature((TemplateSignature) otherEnd, msgs);
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_PARAMETERED_ELEMENT:
			ParameterableElement ownedParameteredElement = basicGetOwnedParameteredElement();
			if (ownedParameteredElement != null)
				msgs = ((InternalEObject) ownedParameteredElement).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_PARAMETERED_ELEMENT, null, msgs);
			return basicSetOwnedParameteredElement((ParameterableElement) otherEnd, msgs);
		}
		return eDynamicInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__EANNOTATIONS:
			return ((InternalEList<?>) getEAnnotations()).basicRemove(otherEnd, msgs);
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_COMMENT:
			return ((InternalEList<?>) getOwnedComments()).basicRemove(otherEnd, msgs);
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_DEFAULT:
			return basicSetOwnedDefault(null, msgs);
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT:
			return basicSetParameteredElement(null, msgs);
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__SIGNATURE:
			return basicSetSignature(null, msgs);
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_PARAMETERED_ELEMENT:
			return basicSetOwnedParameteredElement(null, msgs);
		}
		return eDynamicInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__DEFAULT:
			if (resolve)
				return getDefault();
			return basicGetDefault();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_DEFAULT:
			if (resolve)
				return getOwnedDefault();
			return basicGetOwnedDefault();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT:
			if (resolve)
				return getParameteredElement();
			return basicGetParameteredElement();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__SIGNATURE:
			if (resolve)
				return getSignature();
			return basicGetSignature();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_PARAMETERED_ELEMENT:
			if (resolve)
				return getOwnedParameteredElement();
			return basicGetOwnedParameteredElement();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__DEFAULT:
			setDefault((ParameterableElement) newValue);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_DEFAULT:
			setOwnedDefault((ParameterableElement) newValue);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT:
			setParameteredElement((ParameterableElement) newValue);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__SIGNATURE:
			setSignature((TemplateSignature) newValue);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_PARAMETERED_ELEMENT:
			setOwnedParameteredElement((ParameterableElement) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__DEFAULT:
			setDefault((ParameterableElement) null);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_DEFAULT:
			setOwnedDefault((ParameterableElement) null);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT:
			setParameteredElement((ParameterableElement) null);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__SIGNATURE:
			setSignature((TemplateSignature) null);
			return;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_PARAMETERED_ELEMENT:
			setOwnedParameteredElement((ParameterableElement) null);
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNER:
			return isSetOwner();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__DEFAULT:
			return basicGetDefault() != null;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_DEFAULT:
			return basicGetOwnedDefault() != null;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__PARAMETERED_ELEMENT:
			return isSetParameteredElement();
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__SIGNATURE:
			return basicGetSignature() != null;
		case UMLPackage.CONNECTABLE_ELEMENT_TEMPLATE_PARAMETER__OWNED_PARAMETERED_ELEMENT:
			return basicGetOwnedParameteredElement() != null;
		}
		return eDynamicIsSet(featureID);
	}

} //ConnectableElementTemplateParameterImpl
