/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.figures.ScalableImageFigure;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.BorderDisplayEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.MaintainSymbolRatioEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.BorderedScalableImageFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ScalableCompartmentFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ShapeFlowLayout;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SubCompartmentLayoutManager;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ShapeService;

public class ShapeDisplayCompartmentEditPart
extends ResizableCompartmentEditPart {
    public static final String COMPARTMENT_NAME = "symbol";

    public ShapeDisplayCompartmentEditPart(EObject model) {
        super(model);
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("MAINTAIN_SYMBOL_RATIO_EDITPOLICY", (EditPolicy)new MaintainSymbolRatioEditPolicy());
        this.installEditPolicy("BORDER_DISPLAY_EDITPOLICY", (EditPolicy)new BorderDisplayEditPolicy());
    }

    public String getCompartmentName() {
        return COMPARTMENT_NAME;
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature) || NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {
            this.refresh();
        }
        super.handleNotificationEvent(notification);
    }

    protected void maintainRatio(boolean maintainRatio) {
        IFigure contentPane = ((ResizableCompartmentFigure)this.getFigure()).getContentPane();
        for (Object subFigure : contentPane.getChildren()) {
            if (!(subFigure instanceof BorderedScalableImageFigure)) continue;
            ((BorderedScalableImageFigure)((Object)subFigure)).setMaintainAspectRatio(maintainRatio);
        }
        int nbShapeToDisplay = ShapeService.getInstance().getShapesToDisplay((EObject)this.getPrimaryView()).size();
        if (!maintainRatio && nbShapeToDisplay == 1) {
            layout = new OneShapeLayoutManager();
            contentPane.setLayoutManager((LayoutManager)layout);
        } else {
            layout = new ShapeFlowLayout();
            contentPane.setLayoutManager((LayoutManager)layout);
        }
    }

    public IFigure createFigure() {
        ScalableCompartmentFigure result = new ScalableCompartmentFigure(this.getCompartmentName(), this.getMapMode());
        ShapeCompartmentLayoutManager layoutManager = new ShapeCompartmentLayoutManager();
        result.setLayoutManager((LayoutManager)layoutManager);
        ShapeFlowLayout layout = new ShapeFlowLayout();
        result.getContentPane().setLayoutManager((LayoutManager)layout);
        return result;
    }

    public void refresh() {
        this.refreshShapes(this.getContentPane());
        super.refresh();
    }

    protected void refreshShapes(IFigure contentPane) {
        ArrayList children = new ArrayList(contentPane.getChildren());
        for (Object child : children) {
            if (!(child instanceof IFigure)) continue;
            contentPane.remove((IFigure)child);
        }
        List<RenderedImage> shapesToDisplay = ShapeService.getInstance().getShapesToDisplay(this.getNotationView().eContainer());
        if (shapesToDisplay != null && !shapesToDisplay.isEmpty()) {
            for (RenderedImage image : shapesToDisplay) {
                if (image != null) {
                    BorderedScalableImageFigure imageFigure = new BorderedScalableImageFigure(image, false, this.getUseOriginalColors(), true, true);
                    imageFigure.setOpaque(false);
                    imageFigure.setVisible(true);
                    contentPane.add((IFigure)imageFigure);
                    continue;
                }
                Activator.log.debug("No image will be drawn");
            }
        }
    }

    private boolean getUseOriginalColors() {
        boolean useOriginalColors = true;
        if (this.getParent().getModel() instanceof View) {
            useOriginalColors = NotationUtils.getBooleanValue((View)this.getParent().getModel(), "useOriginalColors", true);
        }
        return useOriginalColors;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshSymbolCompartment();
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    protected void refreshSymbolCompartment() {
        BooleanValueStyle maintainRatio = this.getMaintainSymbolRatioStyle(this.getNotationView());
        if (maintainRatio != null && !maintainRatio.isBooleanValue()) {
            this.maintainRatio(false);
        } else {
            this.maintainRatio(true);
        }
    }

    protected BooleanValueStyle getMaintainSymbolRatioStyle(View currentView) {
        View parentView = currentView;
        while (parentView.getElement() == currentView.getElement()) {
            BooleanValueStyle style = (BooleanValueStyle)parentView.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "maintainSymbolRatio");
            if (style != null) {
                return style;
            }
            if (!(parentView.eContainer() instanceof View)) break;
            parentView = (View)parentView.eContainer();
        }
        return null;
    }

    public boolean isSelectable() {
        return false;
    }

    public class OneShapeLayoutManager
    extends AbstractLayout {
        protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
            int minimumWith = 16;
            int minimumHeight = 16;
            return new Dimension(minimumWith, minimumHeight);
        }

        public void layout(IFigure container) {
            Object lastFig;
            Rectangle compartmentBound = new Rectangle(container.getBounds());
            if (container.getBorder() instanceof MarginBorder) {
                MarginBorder marginBorder = (MarginBorder)container.getBorder();
                compartmentBound = compartmentBound.shrink(marginBorder.getInsets(container));
            }
            IFigure contentPane = ((ResizableCompartmentFigure)ShapeDisplayCompartmentEditPart.this.getFigure()).getContentPane();
            ScalableImageFigure scalableImageFigure = null;
            if (contentPane.getChildren().size() > 0 && (lastFig = contentPane.getChildren().get(contentPane.getChildren().size() - 1)) instanceof ScalableImageFigure) {
                scalableImageFigure = (ScalableImageFigure)lastFig;
            }
            if (scalableImageFigure != null) {
                scalableImageFigure.setBounds(compartmentBound);
            }
        }
    }

    public class ShapeCompartmentLayoutManager
    extends SubCompartmentLayoutManager {
        public static final int MIN_PREFERRED_SIZE = 40;

        @Override
        public void layout(IFigure container) {
            super.layout(container);
            int i = 0;
            while (i < container.getChildren().size()) {
                if (container.getChildren().get(i) instanceof ScrollPane) {
                    ((ScrollPane)container.getChildren().get(i)).setBounds(container.getBounds());
                }
                ++i;
            }
        }

        @Override
        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            Dimension dim = super.calculatePreferredSize(figure, wHint, hHint);
            if (figure.getParent().getBounds().height > 40) {
                dim.height = Math.max(40, dim.height);
            }
            return dim;
        }
    }
}

