/**
 * Copyright (c) 2007-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.expressions;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Objects;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

/**
 * FIXME: [MG] - fieldNames should be xptXXX
 */
@Singleton
@SuppressWarnings("all")
public class getExpression {
  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  private MetaModel xptMetaModel;

  @Inject
  private OCLExpressionFactory oclFactory;

  @Inject
  private RegexpExpressionFactory regexpFactory;

  @MetaDef
  public CharSequence getExpressionBody(final ValueExpression it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _expressionBody = this.getExpressionBody(it.getProvider(), it);
    _builder.append(_expressionBody);
    return _builder;
  }

  @MetaDef
  protected CharSequence _getExpressionBody(final GenExpressionProviderBase it, final ValueExpression valueExpr) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("Abstract template call: getExpression");
    return _builder;
  }

  @MetaDef
  protected CharSequence _getExpressionBody(final GenExpressionInterpreter it, final ValueExpression valueExpr) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _expressionFactory = this.getExpressionFactory(it);
    _builder.append(_expressionFactory);
    _builder.append(".getExpressionBody(");
    int _expressionIndex = getExpression.expressionIndex(it, valueExpr);
    _builder.append(_expressionIndex);
    _builder.append(")");
    return _builder;
  }

  @MetaDef
  protected CharSequence _getExpression(final GenExpressionProviderBase it, final ValueExpression valueExpr, final GenClassifier context) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("Abstract template call: getExpression");
    return _builder;
  }

  @MetaDef
  protected CharSequence _getExpression(final GenExpressionInterpreter it, final ValueExpression valueExpr, final GenClassifier context) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _expression = this.getExpression(it, valueExpr, context, "null");
    _builder.append(_expression);
    return _builder;
  }

  @MetaDef
  protected CharSequence _getExpression(final GenExpressionInterpreter it, final ValueExpression valueExpr, final String contextMetaClassifier) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _expressionFactory = this.getExpressionFactory(it);
    _builder.append(_expressionFactory);
    _builder.append(".");
    String _expressionAccessor = it.getExpressionAccessor(valueExpr);
    _builder.append(_expressionAccessor);
    _builder.append("(");
    int _expressionIndex = getExpression.expressionIndex(it, valueExpr);
    _builder.append(_expressionIndex);
    _builder.append(", ");
    _builder.append(contextMetaClassifier);
    _builder.append(", \'null\')");
    return _builder;
  }

  @MetaDef
  public CharSequence getExpression(final GenExpressionInterpreter it, final ValueExpression valueExpr, final GenClassifier context, final String environmentArg) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _expressionFactory = this.getExpressionFactory(it);
    _builder.append(_expressionFactory);
    _builder.append(".");
    String _expressionAccessor = it.getExpressionAccessor(valueExpr);
    _builder.append(_expressionAccessor);
    _builder.append("(");
    int _expressionIndex = getExpression.expressionIndex(it, valueExpr);
    _builder.append(_expressionIndex);
    _builder.append(", ");
    CharSequence _MetaClass = this.xptMetaModel.MetaClass(context);
    _builder.append(_MetaClass);
    _builder.append(", ");
    _builder.append(environmentArg);
    _builder.append(")");
    return _builder;
  }

  public CharSequence getExpressionFactory(final GenExpressionInterpreter it) {
    GenLanguage _language = it.getLanguage();
    boolean _equals = Objects.equals(_language, GenLanguage.OCL_LITERAL);
    if (_equals) {
      return this.oclFactory.qualifiedClassName(it);
    }
    GenLanguage _language_1 = it.getLanguage();
    boolean _equals_1 = Objects.equals(_language_1, GenLanguage.OCL_LITERAL);
    if (_equals_1) {
      return this.regexpFactory.qualifiedClassName(it);
    }
    return it.getQualifiedClassName();
  }

  /**
   * XXX: [MG] in Xpand, there was additional "-1" here: 'it.expressions.indexOf(expr) - 1', hope in Xtend we don't need it
   */
  private static int expressionIndex(final GenExpressionInterpreter it, final ValueExpression expr) {
    return it.getExpressions().indexOf(expr);
  }

  public CharSequence getExpressionInterpriterQualifiedClassName(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenLanguage _language = it.getLanguage();
      boolean _equals = Objects.equals(_language, GenLanguage.OCL_LITERAL);
      if (_equals) {
        CharSequence _qualifiedClassName = this.oclFactory.qualifiedClassName(it);
        _builder.append(_qualifiedClassName);
        _builder.newLineIfNotEmpty();
      } else {
        GenLanguage _language_1 = it.getLanguage();
        boolean _equals_1 = Objects.equals(_language_1, GenLanguage.REGEXP_LITERAL);
        if (_equals_1) {
          CharSequence _qualifiedClassName_1 = this.regexpFactory.qualifiedClassName(it);
          _builder.append(_qualifiedClassName_1);
          _builder.newLineIfNotEmpty();
        } else {
          GenLanguage _language_2 = it.getLanguage();
          boolean _equals_2 = Objects.equals(_language_2, GenLanguage.JAVA_LITERAL);
          if (_equals_2) {
            String _qualifiedClassName_2 = it.getQualifiedClassName();
            _builder.append(_qualifiedClassName_2);
            _builder.newLineIfNotEmpty();
          } else {
            GenLanguage _language_3 = it.getLanguage();
            boolean _equals_3 = Objects.equals(_language_3, GenLanguage.NREGEXP_LITERAL);
            if (_equals_3) {
              String _qualifiedClassName_3 = it.getQualifiedClassName();
              _builder.append(_qualifiedClassName_3);
              _builder.newLineIfNotEmpty();
            } else {
              GenLanguage _language_4 = it.getLanguage();
              boolean _equals_4 = Objects.equals(_language_4, GenLanguage.LITERAL_LITERAL);
              if (_equals_4) {
                String _qualifiedClassName_4 = it.getQualifiedClassName();
                _builder.append(_qualifiedClassName_4);
                _builder.newLineIfNotEmpty();
              } else {
                this._common_qvto.ERROR(("Language not supported: " + it));
              }
            }
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence getExpressionInterpriterClassName(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenLanguage _language = it.getLanguage();
      boolean _equals = Objects.equals(_language, GenLanguage.OCL_LITERAL);
      if (_equals) {
        CharSequence _className = this.oclFactory.className(it);
        _builder.append(_className);
        _builder.newLineIfNotEmpty();
      } else {
        GenLanguage _language_1 = it.getLanguage();
        boolean _equals_1 = Objects.equals(_language_1, GenLanguage.REGEXP_LITERAL);
        if (_equals_1) {
          CharSequence _className_1 = this.regexpFactory.className(it);
          _builder.append(_className_1);
          _builder.newLineIfNotEmpty();
        } else {
          GenLanguage _language_2 = it.getLanguage();
          boolean _equals_2 = Objects.equals(_language_2, GenLanguage.JAVA_LITERAL);
          if (_equals_2) {
            String _last = IterableExtensions.<String>last(((Iterable<String>)Conversions.doWrapArray(it.getQualifiedClassName().split("\\."))));
            _builder.append(_last);
            _builder.newLineIfNotEmpty();
          } else {
            GenLanguage _language_3 = it.getLanguage();
            boolean _equals_3 = Objects.equals(_language_3, GenLanguage.NREGEXP_LITERAL);
            if (_equals_3) {
              String _last_1 = IterableExtensions.<String>last(((Iterable<String>)Conversions.doWrapArray(it.getQualifiedClassName().split("\\."))));
              _builder.append(_last_1);
              _builder.newLineIfNotEmpty();
            } else {
              GenLanguage _language_4 = it.getLanguage();
              boolean _equals_4 = Objects.equals(_language_4, GenLanguage.LITERAL_LITERAL);
              if (_equals_4) {
                String _last_2 = IterableExtensions.<String>last(((Iterable<String>)Conversions.doWrapArray(it.getQualifiedClassName().split("\\."))));
                _builder.append(_last_2);
                _builder.newLineIfNotEmpty();
              } else {
                this._common_qvto.ERROR(("Language not supported: " + it));
              }
            }
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence getExpressionBody(final GenExpressionProviderBase it, final ValueExpression valueExpr) {
    if (it instanceof GenExpressionInterpreter) {
      return _getExpressionBody((GenExpressionInterpreter)it, valueExpr);
    } else if (it != null) {
      return _getExpressionBody(it, valueExpr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, valueExpr).toString());
    }
  }

  public CharSequence getExpression(final GenExpressionProviderBase it, final ValueExpression valueExpr, final Object context) {
    if (it instanceof GenExpressionInterpreter
         && context instanceof GenClassifier) {
      return _getExpression((GenExpressionInterpreter)it, valueExpr, (GenClassifier)context);
    } else if (it instanceof GenExpressionInterpreter
         && context instanceof String) {
      return _getExpression((GenExpressionInterpreter)it, valueExpr, (String)context);
    } else if (it != null
         && context instanceof GenClassifier) {
      return _getExpression(it, valueExpr, (GenClassifier)context);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, valueExpr, context).toString());
    }
  }
}
