/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import com.google.common.collect.ListMultimap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.properties.environment.Environment;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.IPapyrusBuilderProvider;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PluginCheckerBuilder;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers.PropertiesEnvironmentPluginChecker;
import org.osgi.service.component.annotations.Component;

@Component
public class PropertiesEnvironmentBuilderProvider
implements IPapyrusBuilderProvider {
    public String getProblemMarkerType(PapyrusBuilderKind builderKind) {
        return "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic";
    }

    public boolean providesBuilder(PapyrusBuilderKind builderKind, URI resourceURI) {
        return "environment".equals(resourceURI.fileExtension()) || "xmi".equals(resourceURI.fileExtension()) && this.hasContentType(resourceURI, "org.eclipse.papyrus.infra.properties.environment");
    }

    public AbstractPapyrusBuilder getBuilder(PapyrusBuilderKind builderKind, IProject project) {
        PluginCheckerBuilder result = new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic", this::mapEnvironmentResources);
        switch (builderKind) {
            case MODEL_RESOURCE: {
                result = result.withChecker(PropertiesEnvironmentPluginChecker.modelValidationCheckerFactory()).withChecker(PropertiesEnvironmentPluginChecker.customModelCheckerFactory());
                break;
            }
            case BUNDLE_MANIFEST: {
                result = result.withChecker(PropertiesEnvironmentPluginChecker.buildPropertiesCheckerFactory()).withChecker(PropertiesEnvironmentPluginChecker.modelDependenciesCheckerFactory());
                break;
            }
            case PLUGIN_MANIFEST: {
                result = result.withChecker(PropertiesEnvironmentPluginChecker.extensionsCheckerFactory());
            }
        }
        return result;
    }

    private ListMultimap<IFile, Environment> mapEnvironmentResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(ModelResourceMapper.byExtension((String)"environment").or(ModelResourceMapper.byExtension((String)"xmi").and(ModelResourceMapper.byContentType((String)"org.eclipse.papyrus.infra.properties.environment"))), ModelResourceMapper.resourceSets((EPackage.Registry)ResourceUtils.createWorkspaceAwarePackageRegistry()), ModelResourceMapper.rootsOfType(Environment.class));
    }
}

