/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.ui.utils;

import java.util.List;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public final class UIUtils {
    private static final int WIDTH_HINT = 110;

    private UIUtils() {
    }

    public static Label createLabel(Composite parent, String labelName) {
        Label label = new Label(parent, 0);
        label.setText(labelName);
        label.setLayoutData((Object)UIUtils.getLabelGridData());
        return label;
    }

    public static Button createButton(Composite parent, String text, boolean enabled, SelectionListener selectionListener) {
        Button button = new Button(parent, 0);
        button.setText(text);
        button.setEnabled(enabled);
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static Text createTextField(Composite parent, String text, boolean enabled, ModifyListener modifyListener) {
        Text textField = new Text(parent, 2048);
        textField.setLayoutData((Object)new GridData(768));
        textField.setEnabled(enabled);
        if (text != null) {
            textField.setText(text);
        }
        if (modifyListener != null) {
            textField.addModifyListener(modifyListener);
        }
        return textField;
    }

    public static Combo createCombobox(Composite parent, boolean enabled, List<String> elements, String label, SelectionListener listener) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Label comboboxLabel = new Label(composite, 0);
        comboboxLabel.setText(label);
        GridData gridData = new GridData(4);
        comboboxLabel.setLayoutData((Object)gridData);
        Combo combobox = new Combo(composite, 12);
        combobox.setLayoutData((Object)new GridData(4));
        combobox.setEnabled(enabled);
        for (String element : elements) {
            combobox.add(element);
        }
        combobox.select(0);
        if (listener != null) {
            combobox.addSelectionListener(listener);
        }
        return combobox;
    }

    public static Text createTextArea(Composite parent, String text, boolean enabled, ModifyListener modifyListener) {
        Text textArea = new Text(parent, 2626);
        textArea.setLayoutData((Object)new GridData(1808));
        textArea.setEnabled(enabled);
        if (text != null) {
            textArea.setText(text);
        }
        if (modifyListener != null) {
            textArea.addModifyListener(modifyListener);
        }
        return textArea;
    }

    public static GridData getLabelGridData() {
        GridData labelGridData = new GridData(4);
        labelGridData.widthHint = 110;
        return labelGridData;
    }

    public static Button createCheckbox(Composite composite, boolean enabled, boolean selected, SelectionListener selectionListener) {
        Button checkbox = new Button(composite, 32);
        checkbox.setEnabled(enabled);
        checkbox.setSelection(selected);
        checkbox.setLayoutData((Object)new GridData(768));
        if (selectionListener != null) {
            checkbox.addSelectionListener(selectionListener);
        }
        return checkbox;
    }

    public static Spinner createSpinner(Composite parent, int maxValue, int minValue, int increment, boolean changeable, ModifyListener modifyListener) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setLayoutData((Object)new GridData(768));
        spinner.setMaximum(maxValue);
        spinner.setMinimum(minValue);
        spinner.setIncrement(increment);
        spinner.setEnabled(changeable);
        if (modifyListener != null) {
            spinner.addModifyListener(modifyListener);
        }
        return spinner;
    }
}

