/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.internal.ui.providers;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyToClipboardAction
extends CopyResourceAction {
    protected Clipboard fClipboard;

    public CopyToClipboardAction(IShellProvider shellProvider) {
        super(shellProvider);
    }

    public void run() {
        Display display = this.shellProvider.getShell().getDisplay();
        this.fClipboard = new Clipboard(display);
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        try {
            this.copytoClipboardStructuredSelection(structuredSelection);
        }
        finally {
            this.fClipboard.dispose();
        }
    }

    public void copytoClipboardStructuredSelection(IStructuredSelection selection) {
        Display display = Display.getCurrent();
        Clipboard clipboard = new Clipboard(display);
        Object[] array = selection.toArray();
        IResource[] associatedResources = new IResource[array.length];
        int i = 0;
        while (i < associatedResources.length) {
            Object object = array[i];
            if (object instanceof IResource) {
                associatedResources[i] = (IResource)object;
            }
            ++i;
        }
        clipboard.setContents(new Object[]{associatedResources}, new Transfer[]{ResourceTransfer.getInstance()});
        clipboard.dispose();
    }
}

