/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.infra.base;

public class StringUtils {
    public static final int TABSIZE = 4;

    public static String quote(String str) {
        if (str.startsWith("\"")) {
            return str;
        }
        return "\"" + str + "\"";
    }

    public static String unquote(String str) {
        if (str.startsWith("\"") && str.length() >= 2) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String varName(String aName) {
        aName = aName.replace(".", "_");
        aName = aName.replace("::", "_");
        aName = aName.replace(" ", "_");
        aName = aName.replace("-", "_");
        aName = aName.replace("+", "_");
        aName = aName.replace("?", "_");
        aName = aName.replace("/", "_");
        return aName;
    }

    public static String upperCaseFirst(String str) {
        if (str.length() > 0) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        return str;
    }

    public static String decreaseIndent(char[] contents, int start, int end, int indentation) {
        Object newBlock = "";
        int consume = indentation;
        int i = start;
        while (i < end) {
            char c = contents[i];
            if (consume > 0 && Character.isWhitespace(c)) {
                if (c == '\t') {
                    consume -= 4;
                } else if (c == ' ') {
                    --consume;
                } else {
                    newBlock = (String)newBlock + c;
                }
            } else {
                newBlock = (String)newBlock + c;
                consume = c == '\n' || c == '\r' ? indentation : 0;
            }
            ++i;
        }
        return newBlock;
    }

    public static String append(String str, String appendStr) {
        Object ret = str;
        if (((String)ret).length() > 0) {
            ret = (String)ret + " ";
        }
        ret = (String)ret + appendStr;
        return ret;
    }
}

