/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.debug.data.variables;

import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.ActionActivationValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.ActivityEdgeInstanceValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.CS_EventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.CS_InteractionPointValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.CallEventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.CompletionEventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.DefaultValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.ObjectNodeActivationValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.ObjectTokenValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.ObjectValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.PrimitiveValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.ReferenceValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.SignalEventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.StructuredValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.TimeEventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.TokenValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.TriggeredVisitorValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.UMLValueAdapter;
import org.eclipse.papyrus.moka.engine.uml.time.interfaces.ITimedEventOccurrence;
import org.eclipse.papyrus.moka.fuml.actions.IAcceptEventActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.IActionActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IForkedToken;
import org.eclipse.papyrus.moka.fuml.activities.IObjectNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IObjectToken;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ICallEventOccurrence;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ISignalEventOccurrence;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.loci.additions.ITriggeredVisitorWrapper;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IPrimitiveValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IStructuredValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IReference;
import org.eclipse.papyrus.moka.pscs.commonbehavior.ICS_EventOccurrence;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.ICS_InteractionPoint;
import org.eclipse.papyrus.moka.pssm.statemachines.ICompletionEventOccurrence;
import org.eclipse.papyrus.moka.pssm.statemachines.ITransitionActivation;

public class UMLValueAdapterFactory {
    protected static UMLValueAdapterFactory factory;

    private UMLValueAdapterFactory() {
    }

    public static UMLValueAdapterFactory getInstance() {
        if (factory == null) {
            factory = new UMLValueAdapterFactory();
        }
        return factory;
    }

    public UMLValueAdapter<?> instantiate(Object value, IDebugTarget target) {
        UMLValueAdapter adapter = null;
        if (value != null) {
            if (value instanceof IEventOccurrence) {
                if (value instanceof ICS_EventOccurrence) {
                    adapter = new CS_EventOccurrenceValueAdapter(target, (IEventOccurrence)((ICS_EventOccurrence)value));
                } else if (value instanceof ITimedEventOccurrence) {
                    adapter = new TimeEventOccurrenceValueAdapter(target, (IEventOccurrence)((ITimedEventOccurrence)value));
                } else if (value instanceof ISignalEventOccurrence) {
                    adapter = new SignalEventOccurrenceValueAdapter(target, (IEventOccurrence)((ISignalEventOccurrence)value));
                } else if (value instanceof ICallEventOccurrence) {
                    adapter = new CallEventOccurrenceValueAdapter(target, (IEventOccurrence)((ICallEventOccurrence)value));
                } else if (value instanceof ICompletionEventOccurrence) {
                    adapter = new CompletionEventOccurrenceValueAdapter(target, (IEventOccurrence)((ICompletionEventOccurrence)value));
                }
            } else if (value instanceof IToken) {
                adapter = value instanceof IObjectToken ? new ObjectTokenValueAdapter(target, (IToken)((IObjectToken)value)) : (value instanceof IForkedToken ? this.instantiate(((IForkedToken)value).getBaseToken(), target) : new TokenValueAdapter(target, (IToken)value));
            } else if (value instanceof IValue) {
                if (value instanceof IReference) {
                    adapter = value instanceof ICS_InteractionPoint ? new CS_InteractionPointValueAdapter(target, (ICS_InteractionPoint)value) : new ReferenceValueAdapter(target, (IReference)value);
                } else if (value instanceof IObject_) {
                    adapter = new ObjectValueAdapter(target, (IObject_)value);
                } else if (value instanceof IStructuredValue) {
                    adapter = new StructuredValueAdapter(target, (IStructuredValue)value);
                } else if (value instanceof IPrimitiveValue) {
                    adapter = new PrimitiveValueAdapter(target, (IPrimitiveValue)value);
                }
            } else if (value instanceof ISemanticVisitor) {
                if (value instanceof IActivityNodeActivation) {
                    if (value instanceof IAcceptEventActionActivation) {
                        adapter = new TriggeredVisitorValueAdapter(target, (ITriggeredVisitorWrapper)value);
                    } else if (value instanceof IActionActivation) {
                        adapter = new ActionActivationValueAdapter<IActionActivation>(target, (IActionActivation)value);
                    } else if (value instanceof IObjectNodeActivation) {
                        adapter = new ObjectNodeActivationValueAdapter(target, (IObjectNodeActivation)value);
                    }
                } else if (value instanceof IActivityEdgeInstance) {
                    adapter = new ActivityEdgeInstanceValueAdapter(target, (IActivityEdgeInstance)value);
                } else if (value instanceof ITransitionActivation) {
                    adapter = new TriggeredVisitorValueAdapter(target, (ITriggeredVisitorWrapper)value);
                }
            }
        }
        if (adapter == null) {
            adapter = new DefaultValueAdapter(target, value);
        }
        return adapter;
    }
}

