/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.process;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.papyrus.moka.kernel.MokaKernelActivator;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.kernel.engine.ExecutionEngineException;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.kernel.process.IExecutionEngineContainer;

public class ExecutionEngineJob
extends Job
implements IExecutionEngineContainer {
    protected IExecutionEngine engine;
    protected EngineConfiguration<?> configuration;
    private static final String EXECUTION_ENGINE_JOB_NAME = "Execution Engine Job";

    public ExecutionEngineJob(IExecutionEngine e, EngineConfiguration<?> c) {
        super(EXECUTION_ENGINE_JOB_NAME);
        this.engine = e;
        this.configuration = c;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.engine != null && this.configuration != null) {
            monitor.beginTask("Run execution engine", -1);
            try {
                this.engine.run(this.configuration, SubMonitor.convert((IProgressMonitor)monitor));
            }
            catch (ExecutionEngineException e) {
                this.handleEngineException(e);
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        if (this.engine.canTerminate()) {
            try {
                this.engine.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public IExecutionEngine getExecutionEngine() {
        return this.engine;
    }

    private void handleEngineException(ExecutionEngineException exception) {
        String message = exception.getMessage();
        message = String.valueOf(message) + "\n\n Engine information ---";
        message = String.valueOf(message) + "\n - Status: " + exception.getEngineStatus().toString();
        message = String.valueOf(message) + "\n - ID: " + exception.getEngineID();
        MokaKernelActivator.getDefault().logger.error(message, (Throwable)exception);
    }
}

