/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages.stl.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.robotics.assertions.languages.stl.services.STLGrammarAccess;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.StlTextPackage;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.assignment;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.assignments;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.expression;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.expression_cont;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.expression_start;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.interval;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.num_literal;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.real_expression;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.real_expression_nl;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public class STLSemanticSequencer
extends AbstractDelegatingSemanticSequencer {
    @Inject
    private STLGrammarAccess grammarAccess;

    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set parameters = context.getEnabledBooleanParameters();
        if (epackage == StlTextPackage.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 1: {
                    this.sequence_assignment(context, (assignment)semanticObject);
                    return;
                }
                case 0: {
                    this.sequence_assignments(context, (assignments)semanticObject);
                    return;
                }
                case 2: {
                    this.sequence_expression(context, (expression)semanticObject);
                    return;
                }
                case 4: {
                    this.sequence_expression_cont(context, (expression_cont)semanticObject);
                    return;
                }
                case 3: {
                    this.sequence_expression_start(context, (expression_start)semanticObject);
                    return;
                }
                case 8: {
                    this.sequence_interval(context, (interval)semanticObject);
                    return;
                }
                case 7: {
                    this.sequence_num_literal(context, (num_literal)semanticObject);
                    return;
                }
                case 5: {
                    this.sequence_real_expression(context, (real_expression)semanticObject);
                    return;
                }
                case 6: {
                    this.sequence_real_expression_nl(context, (real_expression_nl)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_assignment(ISerializationContext context, assignment semanticObject) {
        if (this.errorAcceptor != null) {
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)StlTextPackage.Literals.ASSIGNMENT__ID) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)StlTextPackage.Literals.ASSIGNMENT__ID));
            }
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)StlTextPackage.Literals.ASSIGNMENT__EXPR) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)StlTextPackage.Literals.ASSIGNMENT__EXPR));
            }
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getAssignmentAccess().getIdIdentifierTerminalRuleCall_0_0(), (Object)semanticObject.getId());
        feeder.accept(this.grammarAccess.getAssignmentAccess().getExprExpressionParserRuleCall_2_0(), (Object)semanticObject.getExpr());
        feeder.finish();
    }

    protected void sequence_assignments(ISerializationContext context, assignments semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_expression_cont(ISerializationContext context, expression_cont semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_expression(ISerializationContext context, expression semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_expression_start(ISerializationContext context, expression_start semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_interval(ISerializationContext context, interval semanticObject) {
        if (this.errorAcceptor != null) {
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)StlTextPackage.Literals.INTERVAL__TIME1) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)StlTextPackage.Literals.INTERVAL__TIME1));
            }
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)StlTextPackage.Literals.INTERVAL__TIME2) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)StlTextPackage.Literals.INTERVAL__TIME2));
            }
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getIntervalAccess().getTime1IntervalTimeParserRuleCall_1_0(), (Object)semanticObject.getTime1());
        feeder.accept(this.grammarAccess.getIntervalAccess().getTime2IntervalTimeParserRuleCall_3_0(), (Object)semanticObject.getTime2());
        feeder.finish();
    }

    protected void sequence_num_literal(ISerializationContext context, num_literal semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_real_expression_nl(ISerializationContext context, real_expression_nl semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_real_expression(ISerializationContext context, real_expression semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }
}

