/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ScrollableColorMessageDialog
extends TitleAreaDialog {
    private String title;
    private String text;
    private String scrollableText;
    private List<List<Integer>> lines;
    private List<Color> colors;
    private int type;

    public ScrollableColorMessageDialog(Shell parentShell, String title, String text, String scrollableText, int type) {
        this(parentShell, title, text, scrollableText, new ArrayList<List<Integer>>(), new ArrayList<Color>(), type);
    }

    public ScrollableColorMessageDialog(Shell parentShell, String title, String text, String scrollableText) {
        this(parentShell, title, text, scrollableText, 1);
    }

    public ScrollableColorMessageDialog(Shell parentShell, String title, String text, String scrollableText, List<List<Integer>> lines, List<Color> colors) {
        this(parentShell, title, text, scrollableText, lines, colors, 1);
    }

    public ScrollableColorMessageDialog(Shell parentShell, String title, String text, String scrollableText, List<List<Integer>> lines, List<Color> colors, int type) {
        super(parentShell);
        this.title = title;
        this.text = text;
        this.scrollableText = scrollableText;
        this.lines = lines;
        this.colors = colors;
        this.type = type;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        StyledText scrollable = new StyledText(composite, 2824);
        scrollable.setLayoutData((Object)gridData);
        scrollable.setText(this.scrollableText);
        int ci = 0;
        while (ci < this.lines.size()) {
            List<Integer> fline = this.lines.get(ci);
            for (Integer linen : fline) {
                scrollable.setLineBackground(linen.intValue(), 1, this.colors.get(ci));
            }
            ++ci;
        }
        return composite;
    }

    public void create() {
        super.create();
        this.setTitle(this.title);
        this.setMessage(this.text, this.type);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, "OK", true);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollableColorMessageDialog.this.close();
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }
}

