/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.library.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.commands.CancelCommand;
import org.eclipse.papyrus.robotics.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.robotics.core.menu.MenuHelper;
import org.eclipse.papyrus.robotics.core.provider.EClassGraphicalContentProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsContentProvider;
import org.eclipse.papyrus.robotics.library.advice.AdviceUtil;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.CommunicationObject;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinition;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.UMLPackage;

public class SendCommPatternAdvice
extends AbstractEditHelperAdvice {
    public static final String QNAME = "robotics::commpatterns::Send";
    public static final String PREFIX = "S_";

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        DataType message;
        CompositeCommand compositeCommand = new CompositeCommand("Send pattern configuration command");
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Classifier)) {
            return super.getAfterConfigureCommand(request);
        }
        final Classifier classifier = (Classifier)newElement;
        RoboticsContentProvider cp = new RoboticsContentProvider((EObject)classifier, (IStaticContentProvider)new EClassGraphicalContentProvider((EObject)classifier, UMLPackage.eINSTANCE.getDataType()), CommunicationObject.class, ".servicedef.uml");
        EnhancedPopupMenu popupMenu = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for message", (boolean)false);
        Object menuResult = null;
        if (popupMenu.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenu.getSubResult();
        }
        DataType dataType = message = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (message == null) {
            return new CancelCommand((EObject)classifier);
        }
        RecordingCommand templateBinding = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                Classifier sendCommPattern = AdviceUtil.getPattern((Element)classifier, SendCommPatternAdvice.QNAME);
                if (sendCommPattern != null) {
                    TemplateSignature signature = sendCommPattern.getOwnedTemplateSignature();
                    TemplateBinding binding = classifier.createTemplateBinding(signature);
                    TemplateParameter parameter = (TemplateParameter)signature.getOwnedParameters().get(0);
                    TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                    substitution.setFormal(parameter);
                    substitution.setActual((ParameterableElement)message);
                    classifier.setName(SendCommPatternAdvice.PREFIX + message.getName());
                }
                StereotypeUtil.apply((Element)classifier, ServiceDefinition.class);
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)templateBinding));
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }
}

