/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.skillrealization;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.file.FileSystemAccessFactory;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.base.file.ProjectBasedFileAccess;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.python.build.CreateSkillRealizCMakeLists;
import org.eclipse.papyrus.robotics.ros2.codegen.python.build.CreateSkillRealizPackageXML;
import org.eclipse.papyrus.robotics.ros2.codegen.python.skillrealization.CreateSkillRealizationPythonCode;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.ProjectTools;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class CreateSkillRelizationPackage {
    private Map<SkillDefinition, SkillSemantic> skdefToSemanticsMap;
    private Map<Interface, String> serviceToNameMap;
    private Map<String, Interface> nameToServiceMap;

    private static String msgAbortManyNamesForInterface(String ifName, String registeredName, String newName) {
        return String.format("abort transformation, coordination interface (%s) exposed through different names (%s, %s) is not supported.", ifName, registeredName, newName);
    }

    private static String msgAbortIncompatibleServices(String refName, String registeredIfName, String newIfName) {
        return String.format("abort transformation, the same name (%s) cannot be used to refer different Coordination interfaces (%s, %s).", refName, registeredIfName, newIfName);
    }

    public CreateSkillRelizationPackage(Class system, List<Class> components) {
        try {
            HashMap<SkillDefinition, SkillSemantic> _hashMap = new HashMap<SkillDefinition, SkillSemantic>();
            this.skdefToSemanticsMap = _hashMap;
            LinkedHashSet _uniqueSkills = SkillUtils.getUniqueSkills((Class)system);
            for (SkillDefinition skill : _uniqueSkills) {
                this.skdefToSemanticsMap.put(skill, skill.getDefaultSemantic());
            }
            HashMap<Interface, String> _hashMap_1 = new HashMap<Interface, String>();
            this.serviceToNameMap = _hashMap_1;
            HashMap<String, Interface> _hashMap_2 = new HashMap<String, Interface>();
            this.nameToServiceMap = _hashMap_2;
            for (Class component : components) {
                EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
                for (Port port : _allPorts) {
                    if (InteractionUtils.getCommunicationPattern((Port)port) == null || !InteractionUtils.isAction((CommunicationPattern)InteractionUtils.getCommunicationPattern((Port)port))) continue;
                    boolean _containsKey = this.serviceToNameMap.containsKey(InteractionUtils.getServiceDefinition((Port)port));
                    if (_containsKey) {
                        String _name;
                        boolean _notEquals;
                        String _get = this.serviceToNameMap.get(InteractionUtils.getServiceDefinition((Port)port));
                        boolean bl = _notEquals = !Objects.equals(_get, _name = port.getName());
                        if (_notEquals) {
                            String _msgAbortManyNamesForInterface = CreateSkillRelizationPackage.msgAbortManyNamesForInterface(InteractionUtils.getServiceDefinition((Port)port).getName(), this.serviceToNameMap.get(InteractionUtils.getServiceDefinition((Port)port)), port.getName());
                            throw new TransformationException(_msgAbortManyNamesForInterface);
                        }
                    }
                    this.serviceToNameMap.put(InteractionUtils.getServiceDefinition((Port)port), port.getName());
                    boolean _containsKey_1 = this.nameToServiceMap.containsKey(port.getName());
                    if (_containsKey_1) {
                        Interface _serviceDefinition;
                        boolean _tripleNotEquals;
                        Interface _get_1 = this.nameToServiceMap.get(port.getName());
                        boolean bl = _tripleNotEquals = _get_1 != (_serviceDefinition = InteractionUtils.getServiceDefinition((Port)port));
                        if (_tripleNotEquals) {
                            String _msgAbortIncompatibleServices = CreateSkillRelizationPackage.msgAbortIncompatibleServices(port.getName(), this.nameToServiceMap.get(port.getName()).getName(), InteractionUtils.getServiceDefinition((Port)port).getName());
                            throw new TransformationException(_msgAbortIncompatibleServices);
                        }
                    }
                    this.nameToServiceMap.put(port.getName(), InteractionUtils.getServiceDefinition((Port)port));
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void createSkillRealizationPkg(Package pkg) {
        IProject project = ProjectTools.getProject(SkillUtils.realizationPackageName((Package)pkg));
        IPFileSystemAccess fileAccess = FileSystemAccessFactory.create((IProject)project);
        CreateSkillRealizCMakeLists.generate(fileAccess, pkg, this.skdefToSemanticsMap);
        CreateSkillRealizPackageXML.generate(fileAccess, pkg, this.skdefToSemanticsMap);
        ProjectBasedFileAccess _projectBasedFileAccess = new ProjectBasedFileAccess(project, "src");
        CreateSkillRealizationPythonCode.genCode((IPFileSystemAccess)_projectBasedFileAccess, this.skdefToSemanticsMap, this.serviceToNameMap);
    }
}

