/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.fromfile;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.robotics.ros2.reverse.Activator;
import org.eclipse.papyrus.robotics.ros2.reverse.fromfile.ReverseNodeFromSource;

public class ReverseNodesFromWorkspace {
    protected static final String CPP = ".cpp";
    public static final String SRC = "src";
    protected IProject project;
    protected IProgressMonitor monitor;

    public ReverseNodesFromWorkspace(IProject project) {
        this.project = project;
    }

    public void reverseWorkspace(IProgressMonitor monitor) {
        this.monitor = monitor;
        try {
            IResource[] iResourceArray = this.project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource rosPkg = iResourceArray[n2];
                if (rosPkg instanceof IFolder) {
                    this.reverseRosPkg((IFolder)rosPkg);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void reverseRosPkg(IFolder rosPkg) throws CoreException {
        IFolder srcFolder = rosPkg.getFolder(SRC);
        if (srcFolder != null && srcFolder.exists()) {
            this.scanFiles(srcFolder);
        }
    }

    public void scanFiles(IFolder srcFolder) throws CoreException {
        IResource[] iResourceArray = srcFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (this.monitor.isCanceled()) break;
            if (member instanceof IFolder) {
                this.scanFiles((IFolder)member);
            } else if (member instanceof IFile && member.getName().endsWith(CPP)) {
                this.monitor.subTask(String.format("analyze file %s", member.getName()));
                this.monitor.worked(1);
                ReverseNodeFromSource rn = new ReverseNodeFromSource((IFile)member);
                rn.reverseNode(this.monitor, this.project);
            }
            ++n2;
        }
    }
}

