/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.robotics.ros2.codegen.cpp.utils.ProjectTools;
import org.eclipse.papyrus.robotics.ros2.reverse.fromfile.ReverseNodesFromWorkspace;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ReverseNodesFromWorkspaceHandler
extends AbstractHandler {
    protected IProject project;

    public boolean isEnabled() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        Object selected = selection.getFirstElement();
        if (selected instanceof IAdaptable) {
            selected = ((IAdaptable)selected).getAdapter(IProject.class);
        }
        if (selected instanceof IProject) {
            this.project = (IProject)selected;
            return true;
        }
        return false;
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        Shell shell = Display.getCurrent().getActiveShell();
        final boolean configureCDT = MessageDialog.openQuestion((Shell)shell, (String)"Configure CDT project?", (String)"Do you want to configure this project with CDT settings corresponding to the current setup?");
        Job job = new Job("Reverse node from workspace"){

            protected IStatus run(IProgressMonitor monitor) {
                if (configureCDT) {
                    TransformationContext.monitor = monitor;
                    ProjectTools.configureCDT((IProject)ReverseNodesFromWorkspaceHandler.this.project, (String)ReverseNodesFromWorkspaceHandler.this.project.getName());
                }
                ReverseNodesFromWorkspace reverseFromSource = new ReverseNodesFromWorkspace(ReverseNodesFromWorkspaceHandler.this.project);
                reverseFromSource.reverseWorkspace(monitor);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return null;
    }
}

