/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;

public final class ByteIteratorIterate {
    private ByteIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(ByteIterator iterator, ByteProcedure procedure) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public static <R extends MutableByteCollection> R select(ByteIterator iterator, BytePredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            byte item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableByteCollection> R reject(ByteIterator iterator, BytePredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            byte item = iterator.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(ByteIterator iterator, ByteToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            byte item = iterator.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static byte detectIfNone(ByteIterator iterator, BytePredicate predicate, byte ifNone) {
        while (iterator.hasNext()) {
            byte item = iterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(ByteIterator iterator, BytePredicate predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(ByteIterator iterator, BytePredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(ByteIterator iterator, BytePredicate predicate) {
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(ByteIterator iterator, BytePredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(ByteIterator iterator, T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public static long sum(ByteIterator iterator) {
        long sum = 0L;
        while (iterator.hasNext()) {
            sum += (long)iterator.next();
        }
        return sum;
    }

    public static byte max(ByteIterator iterator) {
        byte max = iterator.next();
        while (iterator.hasNext()) {
            byte next = iterator.next();
            if (max >= next) continue;
            max = next;
        }
        return max;
    }

    public static byte min(ByteIterator iterator) {
        byte min = iterator.next();
        while (iterator.hasNext()) {
            byte next = iterator.next();
            if (next >= min) continue;
            min = next;
        }
        return min;
    }
}

