/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture.representation.validator;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.validation.AbstractEObjectDependencyValidator;
import org.eclipse.papyrus.infra.architecture.representation.Activator;
import org.eclipse.papyrus.infra.architecture.representation.ModelRule;
import org.eclipse.papyrus.infra.architecture.representation.OwningRule;
import org.eclipse.papyrus.infra.architecture.representation.RepresentationPackage;

public class ArchitectureRepresentationValidator
extends AbstractEObjectDependencyValidator {
    public static final ArchitectureRepresentationValidator eINSTANCE = new ArchitectureRepresentationValidator();

    private ArchitectureRepresentationValidator() {
    }

    protected EPackage getEPackage() {
        return RepresentationPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 2: {
                return this.validateModelRule((ModelRule)object, diagnostics, context);
            }
            case 3: {
                return this.validateOwningRule((OwningRule)object, diagnostics, context);
            }
        }
        return super.validate(classifierID, object, diagnostics, context);
    }

    private boolean validateModelRule(ModelRule modelRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validateRuleElement(modelRule, RepresentationPackage.eINSTANCE.getModelRule_Element(), diagnostics, context) && this.validateRuleStereotype(modelRule, RepresentationPackage.eINSTANCE.getModelRule_Stereotypes(), diagnostics, context);
    }

    private boolean validateOwningRule(OwningRule owningRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validateRuleElement(owningRule, RepresentationPackage.eINSTANCE.getOwningRule_Element(), diagnostics, context) && this.validateRuleStereotype(owningRule, RepresentationPackage.eINSTANCE.getOwningRule_Stereotypes(), diagnostics, context);
    }

    private boolean validateRuleElement(EObject ruleTovalidate, EReference rule_elementReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClass referencedEClass = (EClass)ruleTovalidate.eGet((EStructuralFeature)rule_elementReference);
        if (referencedEClass != null) {
            String dependencyName;
            Resource resource = ruleTovalidate.eResource();
            String bundleName = RESOURCE_URI_HELPER.getBundleNameFromResource(resource);
            boolean isOK = PROJECT_DEPENDENCY_HELPER.hasDependency(bundleName, dependencyName = RESOURCE_URI_HELPER.getBundleNameFromResource(referencedEClass.eResource()));
            if (!isOK) {
                Diagnostic newDiag = this.createMissingDependenciesDiagnostic(ruleTovalidate, (EStructuralFeature)rule_elementReference, Collections.singletonList(dependencyName));
                diagnostics.add(newDiag);
            }
            return isOK;
        }
        Activator.log.warn(NLS.bind((String)"The object {0} is not supported by the validation for {1} metamodel", (Object)ruleTovalidate, (Object)RepresentationPackage.eINSTANCE.getName()));
        return true;
    }

    private boolean validateRuleStereotype(EObject ruleTovalidate, EReference rule_stereotypesReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }
}

