/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.controlmode.participants;

import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.internationalization.controlmode.Activator;
import org.eclipse.papyrus.infra.internationalization.controlmode.commands.InternationalizationAnnotationControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

public class InternationalizationAnnotationControlParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    private static final String PARTICIPANT_ID = "org.eclipse.papyrus.infra.internationalization.controlmode.InternationalizationAnnotationControlParticipant";

    public String getID() {
        return PARTICIPANT_ID;
    }

    public int getPriority() {
        return 20;
    }

    public boolean provideUnControlCommand(ControlModeRequest request) {
        return false;
    }

    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        return null;
    }

    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        return null;
    }

    public boolean provideControlCommand(ControlModeRequest request) {
        boolean result = false;
        Iterator objectContentsIterator = this.getSourceResource(request).getContents().iterator();
        while (objectContentsIterator.hasNext() && !result) {
            EObject objectContent = (EObject)objectContentsIterator.next();
            if (!(objectContent instanceof EAnnotation) || !"Internationalization".equals(((EAnnotation)objectContent).getSource())) continue;
            result = true;
        }
        return result;
    }

    public ICommand getPreControlCommand(ControlModeRequest request) {
        return null;
    }

    public ICommand getPostControlCommand(ControlModeRequest request) {
        return new InternationalizationAnnotationControlCommand(request, this.getSourceResource(request));
    }

    protected Resource getSourceResource(ControlModeRequest request) {
        Resource oldNotationResource = null;
        try {
            oldNotationResource = request.getModelSet().getResource(this.getOldNotationURI(request), true);
        }
        catch (Exception e) {
            Activator.log.error("Unable to retrieve old notation resource", (Throwable)e);
        }
        return oldNotationResource;
    }

    protected URI getOldNotationURI(ControlModeRequest request) throws ExecutionException {
        URI uri = request.getSourceURI();
        if (uri != null) {
            return uri.trimFileExtension().appendFileExtension("notation");
        }
        throw new ExecutionException("Unable to retreive URI of the old notation model");
    }
}

