/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.rotative;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.sirius.diagram.CustomStyle;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;

public final class RotativeImageHelper {
    public static final String ROTATIVE_PREFIX = "rotative:";
    private static RotativeImageHelper instance;

    private RotativeImageHelper() {
    }

    public static RotativeImageHelper getInstance() {
        if (instance == null) {
            instance = new RotativeImageHelper();
        }
        return instance;
    }

    public String getImagePath(CustomStyle customStyle) {
        return customStyle.getId().substring(ROTATIVE_PREFIX.length());
    }

    public BorderedNodeFigure getBorderedNodeFigure(IGraphicalEditPart editPart) {
        BorderedNodeFigure borderedNodeFigure = null;
        IBorderItemLocator borderItemLocator = this.getBorderItemLocator((EditPart)editPart);
        if (borderItemLocator != null && this.getBorderedShapeEditpart(editPart) != null) {
            IBorderedShapeEditPart borderNodeEditPart = this.getBorderedShapeEditpart(editPart);
            borderedNodeFigure = borderNodeEditPart.getBorderedFigure();
        }
        return borderedNodeFigure;
    }

    private IBorderedShapeEditPart getBorderedShapeEditpart(IGraphicalEditPart editPart) {
        IGraphicalEditPart current = editPart;
        AbstractBorderedShapeEditPart borderedNodeEditPart = null;
        while (current != null && borderedNodeEditPart == null) {
            EditPart parent;
            if (current instanceof AbstractBorderedShapeEditPart) {
                borderedNodeEditPart = (AbstractBorderedShapeEditPart)current;
            }
            if (!((parent = current.getParent()) instanceof IGraphicalEditPart)) continue;
            current = (IGraphicalEditPart)parent;
        }
        return borderedNodeEditPart;
    }

    private IBorderItemLocator getBorderItemLocator(EditPart editPart) {
        org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator borderItemLocator = null;
        IDiagramBorderNodeEditPart borderNodeEditPart = this.getDiagramBorderedNodeEditPart(editPart);
        if (borderNodeEditPart instanceof IBorderItemEditPart) {
            borderItemLocator = ((IBorderItemEditPart)borderNodeEditPart).getBorderItemLocator();
        }
        return borderItemLocator;
    }

    private IDiagramBorderNodeEditPart getDiagramBorderedNodeEditPart(EditPart editPart) {
        EditPart current = editPart;
        IDiagramBorderNodeEditPart borderNodeEditPart = null;
        while (current != null && borderNodeEditPart == null) {
            if (current instanceof IDiagramBorderNodeEditPart) {
                borderNodeEditPart = (IDiagramBorderNodeEditPart)current;
            }
            current = current.getParent();
        }
        return borderNodeEditPart;
    }
}

