/**
 * Copyright (c) 2014, 2021 Borland Software Corporation, Montages, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Anatloyi Tischenko - Initial API and implementation
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class CreationWizard {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private GenDiagram_qvto _genDiagram_qvto;

  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;

  @Inject
  private Externalizer xptExternalizer;

  @Inject
  private CreationWizardPage xptCreationWizardPage;

  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;

  @Inject
  private Activator xptActivator;

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _creationWizardClassName = it.getCreationWizardClassName();
    _builder.append(_creationWizardClassName);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getEditorGen().getEditor().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.jface.wizard.Wizard");
    return _builder;
  }

  public CharSequence implementsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.ui.INewWizard");
    return _builder;
  }

  public CharSequence CreationWizard(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.ui.IWorkbench workbench;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.jface.viewers.IStructuredSelection selection;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected ");
    CharSequence _qualifiedClassName = this.xptCreationWizardPage.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(" diagramModelFilePage;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _standaloneDomainModel = this._genDiagram_qvto.standaloneDomainModel(it);
      if (_standaloneDomainModel) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected ");
        CharSequence _qualifiedClassName_1 = this.xptCreationWizardPage.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_1, "\t");
        _builder.append(" domainModelFilePage;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.emf.ecore.resource.Resource diagram;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private boolean openNewlyCreatedDiagramEditor = true;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.ui.IWorkbench getWorkbench() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return workbench;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.jface.viewers.IStructuredSelection getSelection() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return selection;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public final org.eclipse.emf.ecore.resource.Resource getDiagram() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return diagram;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_9, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public final boolean isOpenNewlyCreatedDiagramEditor() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return openNewlyCreatedDiagramEditor;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_10, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_11, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void init(org.eclipse.ui.IWorkbench workbench, org.eclipse.jface.viewers.IStructuredSelection selection) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.workbench = workbench;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.selection = selection;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setWindowTitle(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizard(it)));
    _builder.append(_accessorCall, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("setDefaultPageImageDescriptor(");
    CharSequence _qualifiedClassName_2 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_2, "\t\t");
    _builder.append(".getBundledImageDescriptor(\"icons/wizban/New");
    {
      GenClass _domainDiagramElement = it.getDomainDiagramElement();
      boolean _tripleNotEquals = (_domainDiagramElement != null);
      if (_tripleNotEquals) {
        String _prefix = it.getDomainDiagramElement().getGenPackage().getPrefix();
        _builder.append(_prefix, "\t\t");
      }
    }
    _builder.append("Wizard.gif\")); //$NON-NLS-1$");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("setNeedsProgressMonitor(true);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_12, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void addPages() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("diagramModelFilePage = new ");
    CharSequence _qualifiedClassName_3 = this.xptCreationWizardPage.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_3, "\t\t");
    _builder.append("(\"DiagramModelFile\", getSelection(), \"");
    String _diagramFileExtension = it.getEditorGen().getDiagramFileExtension();
    _builder.append(_diagramFileExtension, "\t\t");
    _builder.append("\"); //$NON-NLS-1$ //$NON-NLS-2$");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramModelFilePage.setTitle(");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizardDiagramPage(it)));
    _builder.append(_accessorCall_1, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramModelFilePage.setDescription(");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForCreationWizardDiagramPage(it)));
    _builder.append(_accessorCall_2, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("addPage(diagramModelFilePage);");
    _builder.newLine();
    {
      boolean _standaloneDomainModel_1 = this._genDiagram_qvto.standaloneDomainModel(it);
      if (_standaloneDomainModel_1) {
        _builder.append("\t\t");
        _builder.append("domainModelFilePage = new ");
        CharSequence _qualifiedClassName_4 = this.xptCreationWizardPage.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_4, "\t\t");
        _builder.append("(\"DomainModelFile\", getSelection(), \"");
        String _domainFileExtension = it.getEditorGen().getDomainFileExtension();
        _builder.append(_domainFileExtension, "\t\t");
        _builder.append("\") { //$NON-NLS-1$ //$NON-NLS-2$");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _overrideC_2 = this._codeStyle.overrideC(it);
        _builder.append(_overrideC_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("public void setVisible(boolean visible) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("if (visible) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("String fileName = diagramModelFilePage.getFileName();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("fileName = fileName.substring(0, fileName.length() - \".");
        String _diagramFileExtension_1 = it.getEditorGen().getDiagramFileExtension();
        _builder.append(_diagramFileExtension_1, "\t\t\t\t");
        _builder.append("\".length()); //$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("setFileName(");
        CharSequence _qualifiedClassName_5 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_5, "\t\t\t\t");
        _builder.append(".getUniqueFileName(getContainerFullPath(), fileName, \"");
        String _domainFileExtension_1 = it.getEditorGen().getDomainFileExtension();
        _builder.append(_domainFileExtension_1, "\t\t\t\t");
        _builder.append("\")); //$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("super.setVisible(visible);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("domainModelFilePage.setTitle(");
        CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizardDomainPage(it)));
        _builder.append(_accessorCall_3, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("domainModelFilePage.setDescription(");
        CharSequence _accessorCall_4 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForCreationWizardDomainPage(it)));
        _builder.append(_accessorCall_4, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("addPage(domainModelFilePage);");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_13, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_3 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean performFinish() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.operation.IRunnableWithProgress op = ");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _tripleEquals = (_application == null);
      if (_tripleEquals) {
        _builder.append("\t\t");
        _builder.append("new org.eclipse.ui.actions.WorkspaceModifyOperation(null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        CharSequence _overrideC_4 = this._codeStyle.overrideC(it);
        _builder.append(_overrideC_4, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("protected void execute(org.eclipse.core.runtime.IProgressMonitor monitor) throws org.eclipse.core.runtime.CoreException, InterruptedException {");
        _builder.newLine();
      } else {
        _builder.append("\t\t");
        _builder.append("new org.eclipse.jface.operation.IRunnableWithProgress() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append(_overrideI, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("public void run(org.eclipse.core.runtime.IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("diagram = ");
    CharSequence _qualifiedClassName_6 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_6, "\t\t\t");
    _builder.append(".createDiagram(diagramModelFilePage.getURI(), ");
    {
      boolean _standaloneDomainModel_2 = this._genDiagram_qvto.standaloneDomainModel(it);
      if (_standaloneDomainModel_2) {
        _builder.append("domainModelFilePage.getURI(), ");
      }
    }
    _builder.append("monitor);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("if (isOpenNewlyCreatedDiagramEditor() && diagram != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    CharSequence _qualifiedClassName_7 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_7, "\t\t\t\t\t\t");
    _builder.append(".openDiagram(diagram);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("} catch (org.eclipse.ui.PartInitException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("org.eclipse.jface.dialogs.ErrorDialog.openError(getContainer().getShell(), ");
    CharSequence _accessorCall_5 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForCreationWizardOpenEditorError(it));
    _builder.append(_accessorCall_5, "\t\t\t\t\t\t");
    _builder.append(", null, e.getStatus());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("getContainer().run(false, true, op);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (InterruptedException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (java.lang.reflect.InvocationTargetException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (e.getTargetException() instanceof org.eclipse.core.runtime.CoreException) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.jface.dialogs.ErrorDialog.openError(getContainer().getShell(), ");
    CharSequence _accessorCall_6 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForCreationWizardCreationError(it));
    _builder.append(_accessorCall_6, "\t\t\t\t");
    _builder.append(", null, ((org.eclipse.core.runtime.CoreException) e.getTargetException()).getStatus());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    CharSequence _qualifiedClassName_8 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_8, "\t\t\t\t");
    _builder.append(".getInstance().logError(\"Error creating diagram\", e.getTargetException()); //$NON-NLS-1$");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return diagram != null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _titleKey = this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizard(it));
    String _modelID = it.getEditorGen().getModelID();
    String _plus = ("New " + _modelID);
    String _plus_1 = (_plus + " Diagram");
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(_titleKey, _plus_1);
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    String _titleKey_1 = this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizardDiagramPage(it));
    String _modelID_1 = it.getEditorGen().getModelID();
    String _plus_2 = ("Create " + _modelID_1);
    String _plus_3 = (_plus_2 + " Diagram");
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(_titleKey_1, _plus_3);
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    String _descriptionKey = this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForCreationWizardDiagramPage(it));
    String _xifexpression = null;
    boolean _standaloneDomainModel = this._genDiagram_qvto.standaloneDomainModel(it);
    if (_standaloneDomainModel) {
      _xifexpression = "Select file that will contain diagram model.";
    } else {
      _xifexpression = "Select file that will contain diagram and domain models.";
    }
    CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(_descriptionKey, _xifexpression);
    _builder.append(_messageEntry_2);
    _builder.newLineIfNotEmpty();
    {
      boolean _standaloneDomainModel_1 = this._genDiagram_qvto.standaloneDomainModel(it);
      if (_standaloneDomainModel_1) {
        String _titleKey_2 = this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizardDomainPage(it));
        String _modelID_2 = it.getEditorGen().getModelID();
        String _plus_4 = ("Create " + _modelID_2);
        String _plus_5 = (_plus_4 + " Domain Model");
        CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(_titleKey_2, _plus_5);
        _builder.append(_messageEntry_3);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForCreationWizardDomainPage(it)), "Select file that will contain domain model.");
        _builder.append(_messageEntry_4);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _messageEntry_5 = this.xptExternalizer.messageEntry(this.i18nKeyForCreationWizardOpenEditorError(it), "Error opening diagram editor");
    _builder.append(_messageEntry_5);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_6 = this.xptExternalizer.messageEntry(this.i18nKeyForCreationWizardCreationError(it), "Creation Problems");
    _builder.append(_messageEntry_6);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizard(it)));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizardDiagramPage(it)));
    _builder.append(_accessorField_1);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForCreationWizardDiagramPage(it)));
    _builder.append(_accessorField_2);
    _builder.newLineIfNotEmpty();
    {
      boolean _standaloneDomainModel = this._genDiagram_qvto.standaloneDomainModel(it);
      if (_standaloneDomainModel) {
        CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizardDomainPage(it)));
        _builder.append(_accessorField_3);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_4 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForCreationWizardDomainPage(it)));
        _builder.append(_accessorField_4);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _accessorField_5 = this.xptExternalizer.accessorField(this.i18nKeyForCreationWizardOpenEditorError(it));
    _builder.append(_accessorField_5);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_6 = this.xptExternalizer.accessorField(this.i18nKeyForCreationWizardCreationError(it));
    _builder.append(_accessorField_6);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public String i18nKeyForCreationWizard(final GenDiagram diagram) {
    CharSequence _className = this.className(diagram);
    return ("" + _className);
  }

  @Localization
  public String i18nKeyForCreationWizardDiagramPage(final GenDiagram diagram) {
    CharSequence _className = this.className(diagram);
    String _plus = ("" + _className);
    return (_plus + ".DiagramModelFilePage");
  }

  @Localization
  public String i18nKeyForCreationWizardDomainPage(final GenDiagram diagram) {
    CharSequence _className = this.className(diagram);
    String _plus = ("" + _className);
    return (_plus + ".DomainModelFilePage");
  }

  @Localization
  public String i18nKeyForCreationWizardOpenEditorError(final GenDiagram diagram) {
    CharSequence _className = this.className(diagram);
    String _plus = ("" + _className);
    return (_plus + "OpenEditorError");
  }

  @Localization
  public String i18nKeyForCreationWizardCreationError(final GenDiagram diagram) {
    CharSequence _className = this.className(diagram);
    String _plus = ("" + _className);
    return (_plus + "CreationError");
  }
}
