/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class SequenceDiagramSemanticReorderHelper {
    private final SequenceDiagramOrderServices orderService = new SequenceDiagramOrderServices();
    private final SequenceDiagramUMLHelper umlHelper = new SequenceDiagramUMLHelper();

    public Reordering createSemanticReorderEntry(InteractionFragment semanticElement, EAnnotation newEndPredecessor, List<EAnnotation> ends) {
        Element newOwner = this.findNewOwner(semanticElement, newEndPredecessor, ends);
        EReference newContainment = SequenceDiagramSemanticReorderHelper.findFragmentContainment(newOwner);
        List siblings = (List)newOwner.eGet((EStructuralFeature)newContainment);
        InteractionFragment newPredecessor = this.findSemanticPredecessor(newEndPredecessor, siblings, ends);
        return new Reordering(semanticElement, newOwner, newContainment, newPredecessor);
    }

    public Reordering reorderElements(InteractionFragment semanticElement, EAnnotation newEndPredecessor, List<EAnnotation> endsOrdering) {
        Reordering context = this.createSemanticReorderEntry(semanticElement, newEndPredecessor, endsOrdering);
        this.removeInteractionFragment(context.element());
        this.addInteractionFragment(context.element(), context.owner(), context.containment(), context.predecessor());
        return context;
    }

    public void reorderLifeline(Lifeline lifeline, Lifeline predecessor) {
        EList lifelines = lifeline.getInteraction().getLifelines();
        int newPosition = 0;
        if (predecessor != null) {
            newPosition = lifelines.indexOf((Object)predecessor) + 1;
            int currentPosition = lifelines.indexOf((Object)lifeline);
            if (currentPosition < newPosition) {
                --newPosition;
            }
        }
        lifelines.move(newPosition, (Object)lifeline);
    }

    private Element findNewOwner(InteractionFragment element, EAnnotation newEndPredecessor, List<EAnnotation> ends) {
        Element baseElement = this.umlHelper.getBaseElement(element);
        int finishIndex = ends.indexOf(this.orderService.getFinishingEnd(baseElement));
        int i = ends.indexOf(newEndPredecessor);
        while (i >= 0) {
            InteractionFragment semanticEnd;
            EAnnotation beforeEnd;
            EAnnotation previous = ends.get(i);
            if (this.orderService.getEndOwner(previous) != baseElement && this.orderService.isStartingEnd(previous) && finishIndex <= ends.indexOf(beforeEnd = this.orderService.getFinishingEnd(this.umlHelper.getBaseElement(semanticEnd = this.orderService.getEndFragment(previous)))) && SequenceDiagramSemanticReorderHelper.isApplicableOwner(semanticEnd, element) && this.umlHelper.isCoveringASubsetOf(element, semanticEnd)) {
                return semanticEnd;
            }
            --i;
        }
        return this.umlHelper.getOwningInteraction((Element)element);
    }

    private static boolean isApplicableOwner(InteractionFragment parent, InteractionFragment element) {
        return element instanceof InteractionOperand ? parent instanceof CombinedFragment : parent instanceof Interaction || parent instanceof InteractionOperand;
    }

    public static EReference findFragmentContainment(Element owner) {
        Object result = owner instanceof Interaction ? UMLPackage.eINSTANCE.getInteraction_Fragment() : (owner instanceof InteractionOperand ? UMLPackage.eINSTANCE.getInteractionOperand_Fragment() : (owner instanceof CombinedFragment ? UMLPackage.eINSTANCE.getCombinedFragment_Operand() : null));
        return result;
    }

    private InteractionFragment findSemanticPredecessor(EAnnotation previousEnd, List<?> siblings, List<EAnnotation> ends) {
        int i = ends.indexOf(previousEnd);
        while (i >= 0) {
            EAnnotation end = ends.get(i);
            InteractionFragment previous = this.orderService.getEndFragment(end);
            if (siblings.contains(previous)) {
                InteractionFragment associated = this.getAssociatedFragment(previous);
                if (associated != null) {
                    previous = associated;
                }
                return previous;
            }
            --i;
        }
        return null;
    }

    public void addInteractionFragment(InteractionFragment fragment, Element newOwner, EReference containmentReference, InteractionFragment semanticPredecessor) {
        List containment = (List)newOwner.eGet((EStructuralFeature)containmentReference);
        int newElementIndex = containment.indexOf(semanticPredecessor) + 1;
        containment.add(newElementIndex, fragment);
        InteractionFragment associated = this.getAssociatedFragment(fragment);
        if (associated != null) {
            containment.add(newElementIndex + 1, associated);
        }
    }

    private void removeInteractionFragment(InteractionFragment fragment) {
        Element owner = fragment.getOwner();
        EReference containmentReference = SequenceDiagramSemanticReorderHelper.findFragmentContainment(owner);
        List containment = (List)owner.eGet((EStructuralFeature)containmentReference);
        containment.remove(fragment);
        InteractionFragment associated = this.getAssociatedFragment(fragment);
        if (associated != null) {
            containment.remove(associated);
        }
    }

    /*
     * WARNING - void declaration
     */
    private InteractionFragment getAssociatedFragment(InteractionFragment it) {
        InteractionFragment interactionFragment = it;
        if (interactionFragment instanceof OccurrenceSpecification) {
            void occurence;
            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)interactionFragment;
            OccurrenceSpecification cfr_ignored_0 = (OccurrenceSpecification)interactionFragment;
            return OccurrenceSpecificationHelper.getExecutionFromStartOccurrence((OccurrenceSpecification)occurence).orElse(null);
        }
        return null;
    }

    public void alignLifelinesCoverage(Interaction root, Set<Lifeline> lifelines) {
        lifelines.forEach(lifeline -> {
            int n = this.alignLifelineEvents((Lifeline)lifeline, 0, (List<? extends InteractionFragment>)root.getFragments());
        });
    }

    /*
     * WARNING - void declaration
     */
    private int alignLifelineEvents(Lifeline lifeline, int index, List<? extends InteractionFragment> fragments) {
        int cursor = index;
        EList order = lifeline.getCoveredBys();
        for (InteractionFragment interactionFragment : fragments) {
            void composite;
            if (!interactionFragment.getCovereds().contains((Object)lifeline)) continue;
            if (order.get(cursor) != interactionFragment) {
                lifeline.getCoveredBys().move(cursor, (Object)interactionFragment);
            }
            if (++cursor == lifeline.getCoveredBys().size()) {
                return cursor;
            }
            InteractionFragment interactionFragment2 = interactionFragment;
            if (interactionFragment2 instanceof CombinedFragment) {
                void composite2;
                CombinedFragment cfr_ignored_0 = (CombinedFragment)interactionFragment2;
                CombinedFragment cfr_ignored_1 = (CombinedFragment)interactionFragment2;
                cursor = this.alignLifelineEvents(lifeline, cursor, (List<? extends InteractionFragment>)composite2.getOperands());
                continue;
            }
            InteractionFragment interactionFragment22 = interactionFragment;
            if (!(interactionFragment22 instanceof InteractionOperand)) continue;
            InteractionOperand cfr_ignored_2 = (InteractionOperand)interactionFragment22;
            InteractionOperand cfr_ignored_3 = (InteractionOperand)interactionFragment22;
            cursor = this.alignLifelineEvents(lifeline, cursor, (List<? extends InteractionFragment>)composite.getFragments());
        }
        return cursor;
    }

    public record Reordering(InteractionFragment element, Element owner, EReference containment, InteractionFragment predecessor) {
    }
}

