/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.DuplicateViewsCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.notation.View;

public class PapyrusDuplicateViewsCommand
extends DuplicateViewsCommand
implements ICommand {
    protected View container = null;

    public PapyrusDuplicateViewsCommand(TransactionalEditingDomain editingDomain, String label, DuplicateRequest request, List viewsToDuplicate, Map duplicatedElements, Point offset, View container) {
        super(editingDomain, label, request, viewsToDuplicate, duplicatedElements, offset);
        this.container = container;
    }

    public boolean canExecute() {
        for (EObject original : this.getObjectsToBeDuplicated()) {
            if (original.eContainer() == null) {
                return true;
            }
            EReference reference = original.eContainmentFeature();
            if (reference != null && FeatureMapUtil.isMany((EObject)original.eContainer(), (EStructuralFeature)reference)) continue;
            return false;
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doExecuteWithResult(progressMonitor, info);
        if (result.getReturnValue() instanceof List) {
            List duplicatedObject = (List)result.getReturnValue();
            for (Object object : duplicatedObject) {
                View duplicatedView;
                if (!(object instanceof View) || (duplicatedView = (View)object).eContainer() != null || this.container == null) continue;
                ViewUtil.insertChildView((View)this.container, (View)duplicatedView, (int)-1, (boolean)true);
            }
        }
        return result;
    }
}

