/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager;

import java.io.Reader;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IPasteConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.CreatableEObjectAxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.PapyrusNattableMultiStatus;
import org.eclipse.papyrus.infra.nattable.utils.PapyrusNattableStatus;
import org.eclipse.papyrus.infra.nattable.utils.PasteConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteEnablementStatus;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public abstract class AbstractPasteImportInsertInNattableManager {
    protected final int preferredUserAction;
    protected final CSVPasteHelper pasteHelper;
    protected final INattableModelManager tableManager;
    protected final boolean useProgressMonitorDialog;
    protected final TableSelectionWrapper tableSelectionWrapper;
    protected final boolean openDialog;

    public AbstractPasteImportInsertInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog, boolean openDialog, int preferredUserAction) {
        this(tableManager, pasteHelper, useProgressMonitorDialog, openDialog, preferredUserAction, null);
    }

    public AbstractPasteImportInsertInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog, boolean openDialog, int preferredUserAction, TableSelectionWrapper tableSelectionWrapper) {
        this.pasteHelper = pasteHelper;
        this.tableManager = tableManager;
        this.useProgressMonitorDialog = useProgressMonitorDialog;
        this.openDialog = openDialog;
        this.preferredUserAction = preferredUserAction;
        this.tableSelectionWrapper = tableSelectionWrapper;
    }

    public abstract IStatus doAction();

    protected IStatus getFirstNonOKStatus(IStatus status) {
        if (status != null && !status.isOK()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus current = iStatusArray[n2];
                if (!current.isOK()) {
                    if (current.isMultiStatus()) {
                        return this.getFirstNonOKStatus(current);
                    }
                    return current;
                }
                ++n2;
            }
        }
        return null;
    }

    protected LabelProviderService getLabelProviderService(IConfigRegistry registry) {
        return (LabelProviderService)registry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"label_provider_service_id"});
    }

    protected IStatus verifyColumnCountOnFirstLine(INattableModelManager tableManager, Reader reader) {
        int axisCount = tableManager.getColumnCount();
        CSVParser parser = this.pasteHelper.createParser(reader);
        RowIterator rowIter = parser.parse();
        int nbCell = 0;
        if (rowIter.hasNext()) {
            CellIterator cellIter = (CellIterator)rowIter.next();
            while (cellIter.hasNext()) {
                cellIter.next();
                ++nbCell;
            }
        }
        if (axisCount == 0) {
            return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheTableDoesntHaveColumns);
        }
        if (axisCount == nbCell) {
            return new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_NumberOfColumnsAreEquals);
        }
        return new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_NumberOfColumnsAreNotEquals, (Object)nbCell, (Object)axisCount));
    }

    protected PasteEnablementStatus findPasteModeFromTableConfiguration(INattableModelManager tableManager) {
        if (TableHelper.isTreeTable(tableManager)) {
            return this.findPasteModeFromTableConfigurationForTreeTable(tableManager);
        }
        return this.findPasteModeFromTableConfigurationForNormalTable(tableManager);
    }

    protected PasteEnablementStatus findPasteModeFromTableConfigurationForTreeTable(INattableModelManager tableManager) {
        PapyrusNattableMultiStatus pasteRowsStatus = AbstractPasteImportInsertInNattableManager.canPasteAxis_verifyPasteConfigurationForTreeTable(tableManager);
        boolean fullSynchro = FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(tableManager.getTable(), 0);
        if (fullSynchro) {
            pasteRowsStatus = AbstractPasteImportInsertInNattableManager.canPasteAxis_verifyPasteConfiguration(tableManager, false);
        }
        PasteEnablementStatus pasteStatus = new PasteEnablementStatus(null, pasteRowsStatus);
        return pasteStatus;
    }

    protected PasteEnablementStatus findPasteModeFromTableConfigurationForNormalTable(INattableModelManager tableManager) {
        PapyrusNattableMultiStatus pasteRowsStatus = AbstractPasteImportInsertInNattableManager.canPasteAxis_verifyPasteConfiguration(tableManager, false);
        PapyrusNattableMultiStatus pasteColumnsStatus = AbstractPasteImportInsertInNattableManager.canPasteAxis_verifyPasteConfiguration(tableManager, true);
        PasteEnablementStatus pasteStatus = new PasteEnablementStatus(pasteColumnsStatus, pasteRowsStatus);
        return pasteStatus;
    }

    protected static PapyrusNattableMultiStatus canPasteAxis_verifyPasteConfigurationForTreeTable(INattableModelManager tableManager) {
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String axisName = Messages.AbstractPasteImportInsertInNattableManager_row;
        PapyrusNattableMultiStatus status = null;
        for (TreeFillingConfiguration current : FillingConfigurationUtils.getAllTreeFillingConfiguration(tableManager.getTable())) {
            PasteEObjectConfiguration conf = current.getPasteConfiguration();
            if (!(conf instanceof PasteEObjectConfiguration)) continue;
            status = new PapyrusNattableMultiStatus("org.eclipse.papyrus.infra.nattable", 0, NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_EnablementStatusForPasteInTheTable, (Object)axisName), null);
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_TheTableHasAConfigurationToPaste, (Object)axisName)));
            if (!status.isOK() || current.getDepth() != 0) continue;
            PasteEObjectConfiguration pasteConfiguration = conf;
            IStatus consistentPasteEObjectConfigurationStatus = PasteConfigurationUtils.hasConsistentPasteEObjectConfiguration(pasteConfiguration);
            if (!consistentPasteEObjectConfigurationStatus.isOK()) {
                status.add(new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", consistentPasteEObjectConfigurationStatus.getMessage()));
            } else {
                status.add(consistentPasteEObjectConfigurationStatus);
            }
            if (!status.isOK()) continue;
            EStructuralFeature containmentFeature = pasteConfiguration.getPasteElementContainementFeature();
            if (tableManager.getTable().getContext().eClass().getEAllStructuralFeatures().contains((Object)containmentFeature)) {
                status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheContextOfTheTableHasTheContainmentFeatureDefinedForThePaste));
            } else {
                status.add(new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheContextOfTheTableHasNotTheContainmentFeatureDefinedForThePaste));
            }
            if (!status.isOK()) continue;
            String elementId = pasteConfiguration.getPastedElementId();
            if (CreatableEObjectAxisUtils.getCreatableElementIds(tableManager, false).contains(elementId)) {
                status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_TheTableCanCreateElement, (Object)elementId, (Object)axisName)));
                continue;
            }
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_TheTableCantCreateElement, (Object)elementId, (Object)axisName)));
        }
        return status;
    }

    protected static PapyrusNattableMultiStatus canPasteAxis_verifyPasteConfiguration(INattableModelManager tableManager, boolean columnAxis) {
        IPasteConfiguration conf = (IPasteConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(tableManager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), columnAxis);
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String axisName = columnAxis ? Messages.AbstractPasteImportInsertInNattableManager_column : Messages.AbstractPasteImportInsertInNattableManager_row;
        PapyrusNattableMultiStatus status = null;
        if (conf instanceof PasteEObjectConfiguration) {
            status = new PapyrusNattableMultiStatus("org.eclipse.papyrus.infra.nattable", 0, NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_EnablementStatusForPasteInTheTable, (Object)axisName), null);
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_TheTableHasAConfigurationToPaste, (Object)axisName)));
            if (status.isOK()) {
                PasteEObjectConfiguration pasteConfiguration = (PasteEObjectConfiguration)conf;
                IStatus consistentPasteEObjectConfigurationStatus = PasteConfigurationUtils.hasConsistentPasteEObjectConfiguration(pasteConfiguration);
                if (!consistentPasteEObjectConfigurationStatus.isOK()) {
                    status.add(new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", consistentPasteEObjectConfigurationStatus.getMessage()));
                } else {
                    status.add(consistentPasteEObjectConfigurationStatus);
                }
                if (status.isOK()) {
                    EStructuralFeature containmentFeature = pasteConfiguration.getPasteElementContainementFeature();
                    if (tableManager.getTable().getContext().eClass().getEAllStructuralFeatures().contains((Object)containmentFeature)) {
                        status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheContextOfTheTableHasTheContainmentFeatureDefinedForThePaste));
                    } else {
                        status.add(new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheContextOfTheTableHasNotTheContainmentFeatureDefinedForThePaste));
                    }
                    if (status.isOK()) {
                        String elementId = pasteConfiguration.getPastedElementId();
                        if (CreatableEObjectAxisUtils.getCreatableElementIds(tableManager, columnAxis).contains(elementId)) {
                            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_TheTableCanCreateElement, (Object)elementId, (Object)axisName)));
                        } else {
                            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_TheTableCantCreateElement, (Object)elementId, (Object)axisName)));
                        }
                    }
                }
            }
        }
        return status;
    }

    protected static PasteEnablementStatus findPasteConfigurationAxisIdentifier(INattableModelManager manager) {
        boolean fullSynchro;
        PapyrusNattableMultiStatus status = null;
        status = TableHelper.isTreeTable(manager) ? ((fullSynchro = FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(manager.getTable(), 0)) ? AbstractPasteImportInsertInNattableManager.canPasteAxis_verifyPasteConfigurationAxisIdentifierForNormalTable(manager) : AbstractPasteImportInsertInNattableManager.canPasteAxis_verifyPasteConfigurationAxisIdentifierForTreeTable(manager)) : AbstractPasteImportInsertInNattableManager.canPasteAxis_verifyPasteConfigurationAxisIdentifierForNormalTable(manager);
        PasteEnablementStatus pasteStatus = new PasteEnablementStatus(null, status);
        return pasteStatus;
    }

    protected static PapyrusNattableMultiStatus canPasteAxis_verifyPasteConfigurationAxisIdentifierForTreeTable(INattableModelManager manager) {
        PapyrusNattableMultiStatus status = null;
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String axisName = Messages.AbstractPasteImportInsertInNattableManager_row;
        for (TreeFillingConfiguration current : FillingConfigurationUtils.getAllTreeFillingConfiguration(manager.getTable())) {
            PasteEObjectConfiguration conf = current.getPasteConfiguration();
            if (current.getDepth() != 0 || !(conf instanceof PasteEObjectConfiguration)) continue;
            status = new PapyrusNattableMultiStatus("org.eclipse.papyrus.infra.nattable", 0, NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_EnablementStatusForPasteInTheTable, (Object)axisName), null);
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_TheTableHasAConfigurationToPaste, (Object)axisName)));
            if (!status.isOK()) continue;
            PasteEObjectConfiguration pasteConfiguration = conf;
            IAxis axisIdentifier = pasteConfiguration.getAxisIdentifier();
            if (axisIdentifier != null) {
                status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_PasteConfigurationAxisIdentifierHasBeenSet));
                continue;
            }
            status.add(new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_PasteConfigurationAxisIdentifierHasNotBeenSet));
        }
        return status;
    }

    protected static PapyrusNattableMultiStatus canPasteAxis_verifyPasteConfigurationAxisIdentifierForNormalTable(INattableModelManager manager) {
        IPasteConfiguration conf = (IPasteConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(manager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String axisName = Messages.AbstractPasteImportInsertInNattableManager_row;
        PapyrusNattableMultiStatus status = null;
        if (conf instanceof PasteEObjectConfiguration) {
            status = new PapyrusNattableMultiStatus("org.eclipse.papyrus.infra.nattable", 0, NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_EnablementStatusForPasteInTheTable, (Object)axisName), null);
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_TheTableHasAConfigurationToPaste, (Object)axisName)));
            if (status.isOK()) {
                PasteEObjectConfiguration pasteConfiguration = (PasteEObjectConfiguration)conf;
                IAxis axisIdentifier = pasteConfiguration.getAxisIdentifier();
                if (axisIdentifier != null) {
                    status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_PasteConfigurationAxisIdentifierHasBeenSet));
                } else {
                    status.add(new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_PasteConfigurationAxisIdentifierHasNotBeenSet));
                }
            }
        }
        return status;
    }

    protected IStatus checkTreeTableConfiguration(INattableModelManager manager, int maxDepth) {
        IStatus status = Status.OK_STATUS;
        List<Integer> hiddenCategories = StyleUtils.getHiddenDepths(manager);
        for (Integer n : hiddenCategories) {
            int size;
            if (n > maxDepth || (size = FillingConfigurationUtils.getAllTreeFillingConfigurationForDepth(manager.getTable(), n).size()) <= 1) continue;
            status = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", 3, NLS.bind((String)Messages.AbstractPasteImportInsertInNattableManager_YouHaveMoreThan1Category, (Object)n), null);
        }
        if (status.isOK()) {
            for (TreeFillingConfiguration treeFillingConfiguration : FillingConfigurationUtils.getAllTreeFillingConfiguration(manager.getTable())) {
                EStructuralFeature feature;
                if (treeFillingConfiguration.getDepth() > maxDepth) continue;
                PasteEObjectConfiguration conf = treeFillingConfiguration.getPasteConfiguration();
                if (conf == null) {
                    status = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", 1, Messages.AbstractPasteImportInsertInNattableManager_ThereIsNoPasteConfgurationForATreeFillingConfiguration, null);
                    continue;
                }
                String elementTypeId = conf.getPastedElementId();
                if (elementTypeId == null || elementTypeId.isEmpty()) {
                    status = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", 2, Messages.AbstractPasteImportInsertInNattableManager_ThereIsNoElementIdDefinedInThePasteConfiguration, null);
                } else if (!ElementTypeUtils.getAllExistingElementTypesIds().contains(elementTypeId)) {
                    status = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", 4, String.format(Messages.AbstractPasteImportInsertInNattableManager_TheElementTypeIsUnknown, elementTypeId), null);
                }
                if (!status.isOK() || (feature = conf.getPasteElementContainementFeature()) != null) continue;
                IAxis axis = treeFillingConfiguration.getAxisUsedAsAxisProvider();
                NatTable natTable = (NatTable)manager.getAdapter(NatTable.class);
                LabelProviderContextElementWrapper wrapper = new LabelProviderContextElementWrapper();
                wrapper.setObject(axis);
                wrapper.setConfigRegistry(natTable.getConfigRegistry());
                LabelProviderService serv = (LabelProviderService)natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"label_provider_service_id"});
                ILabelProvider p = serv.getLabelProvider((Object)wrapper);
                p = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.header.labelprovider");
                String categoryName = p.getText((Object)axis);
                status = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", 0, String.format(Messages.AbstractPasteImportInsertInNattableManager_PasteConfigurationFeatureHasNotBeenSet, categoryName, treeFillingConfiguration.getDepth()), null);
            }
        }
        return status;
    }

    protected abstract Reader createReader();

    protected abstract long getDataSize();
}

