/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.papyrus.uml.tools.utils.OperationUtil;
import org.eclipse.uml2.uml.Operation;

public class OperationLabelHelper
extends StereotypedElementLabelHelper {
    private static OperationLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    public static OperationLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new OperationLabelHelper();
        }
        return labelHelper;
    }

    protected OperationLabelHelper() {
        this.masks.put("visibility", "Visibility");
        this.masks.put("name", "Name");
        this.masks.put("parametersName", "Parameters Name");
        this.masks.put("parametersDirection", "Parameters Direction");
        this.masks.put("parametersType", "Parameters Type");
        this.masks.put("returnType", "Return Type");
        this.masks.put("returnMultiplicity", "Return Multiplicity");
        this.masks.put("parametersMultiplicity", "Parameters Multiplicity");
        this.masks.put("parametersDefault", "Parameters Default Value");
        this.masks.put("parametersModifiers", "Parameters Modifiers");
        this.masks.put("modifiers", "Modifiers");
    }

    @Override
    protected String elementLabel(GraphicalEditPart editPart) {
        String elementLabel = "";
        Operation umlElement = this.getUMLElement(editPart);
        if (umlElement != null) {
            Collection displayValue = ICustomAppearance.DEFAULT_UML_OPERATION;
            IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
            if (policy != null) {
                displayValue = policy.getCurrentDisplayValue();
            }
            elementLabel = OperationUtil.getCustomLabel((Operation)umlElement, (Collection)displayValue);
        }
        return elementLabel;
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public Operation getUMLElement(GraphicalEditPart editPart) {
        Operation operation = null;
        Object model = editPart.getModel();
        if (model instanceof View) {
            View view = (View)model;
            EObject element = view.getElement();
            if (element instanceof Operation) {
                operation = (Operation)element;
            } else {
                Activator.log.warn("Operation Label Helper should only be applied on operation. Probably something else is present in the operation compartment, check: " + EcoreUtil.getID((EObject)view) + " or " + EcoreUtil.getIdentification((EObject)view));
            }
        }
        return operation;
    }
}

