/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.common.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.nattableconfiguration.NattableConfigurationRegistry;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ChooseNattableConfigWizardPage
extends WizardPage {
    private Map<ViewPrototype, Integer> selectedViewPrototypes = new HashMap<ViewPrototype, Integer>();
    private Map<ViewPrototype, String> tableNames = new HashMap<ViewPrototype, String>();
    private EObject context;
    private static final Image CHECKED = Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable.common", "icons/checked.gif");
    private static final Image UNCHECKED = Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable.common", "icons/unchecked.gif");

    protected ChooseNattableConfigWizardPage(String pageName, EObject context) {
        super(pageName);
        this.context = context;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.createTableViewer(container);
        this.setControl((Control)container);
    }

    public void createTableViewer(final Composite container) {
        final TableViewer viewer = new TableViewer(container, 68354);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        TableViewerColumn colCheckbox = this.createTableViewerColumn("", 23, viewer);
        Collection<ViewPrototype> viewPrototypes = this.loadConfigs();
        final HashMap<ViewPrototype, TableConfiguration> tableConfigurations = new HashMap<ViewPrototype, TableConfiguration>(viewPrototypes.size());
        for (ViewPrototype viewPrototype : viewPrototypes) {
            tableConfigurations.put(viewPrototype, this.getTableConfiguration((TableViewPrototype)viewPrototype));
        }
        colCheckbox.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                if (ChooseNattableConfigWizardPage.this.selectedViewPrototypes.containsKey(element)) {
                    return CHECKED;
                }
                return UNCHECKED;
            }
        });
        colCheckbox.setEditingSupport(new EditingSupport((ColumnViewer)viewer){
            private CheckboxCellEditor checkboxCellEditor;

            protected void setValue(Object element, Object value) {
                if (Boolean.TRUE.equals(this.checkboxCellEditor.getValue())) {
                    ChooseNattableConfigWizardPage.this.selectedViewPrototypes.put((ViewPrototype)element, 1);
                } else {
                    ChooseNattableConfigWizardPage.this.selectedViewPrototypes.remove(element);
                }
                viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                return ChooseNattableConfigWizardPage.this.selectedViewPrototypes.containsKey(element);
            }

            protected CellEditor getCellEditor(Object element) {
                this.checkboxCellEditor = new CheckboxCellEditor(container, 40);
                return this.checkboxCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn colType = this.createTableViewerColumn(Messages.ChooseNattableConfigWizardPage_6, 250, viewer);
        colType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ViewPrototype viewPrototype = (ViewPrototype)element;
                return viewPrototype.getRepresentationKind().getImplementationID();
            }

            public Image getImage(Object element) {
                ViewPrototype viewPrototype = (ViewPrototype)element;
                TableConfiguration tableConfiguration = (TableConfiguration)tableConfigurations.get(viewPrototype);
                Image image = Activator.getDefault().getImage(tableConfiguration.getIconPath());
                return image;
            }
        });
        TableViewerColumn colName = this.createTableViewerColumn(Messages.ChooseNattableConfigWizardPage_7, 200, viewer);
        colName.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected void setValue(Object element, Object value) {
                ChooseNattableConfigWizardPage.this.tableNames.put((ViewPrototype)element, (String)value);
                viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                if (ChooseNattableConfigWizardPage.this.tableNames.containsKey(element)) {
                    return ChooseNattableConfigWizardPage.this.tableNames.get(element);
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)viewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)ChooseNattableConfigWizardPage.this.tableNames.get(element);
            }
        });
        TableViewerColumn colQuantity = this.createTableViewerColumn(Messages.ChooseNattableConfigWizardPage_9, 30, viewer);
        colQuantity.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected void setValue(Object element, Object value) {
                if (value.toString().isEmpty()) {
                    ChooseNattableConfigWizardPage.this.selectedViewPrototypes.put((ViewPrototype)element, 1);
                } else {
                    ChooseNattableConfigWizardPage.this.selectedViewPrototypes.put((ViewPrototype)element, Integer.parseInt((String)value));
                }
                viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                if (ChooseNattableConfigWizardPage.this.selectedViewPrototypes.containsKey(element)) {
                    return ((Integer)ChooseNattableConfigWizardPage.this.selectedViewPrototypes.get(element)).toString();
                }
                return "0";
            }

            protected CellEditor getCellEditor(Object element) {
                TextCellEditor textCellEditor = new TextCellEditor((Composite)viewer.getTable());
                textCellEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        if (!(value instanceof Integer)) {
                            return null;
                        }
                        return value.toString();
                    }
                });
                return textCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        colQuantity.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (ChooseNattableConfigWizardPage.this.selectedViewPrototypes.containsKey(element)) {
                    return ((Integer)ChooseNattableConfigWizardPage.this.selectedViewPrototypes.get(element)).toString();
                }
                return "";
            }
        });
        TableViewerColumn colDescription = this.createTableViewerColumn(Messages.ChooseNattableConfigWizardPage_12, 400, viewer);
        colDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ViewPrototype viewPrototype = (ViewPrototype)element;
                TableConfiguration tableConfiguration = (TableConfiguration)tableConfigurations.get(viewPrototype);
                return tableConfiguration.getDescription();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ChooseNattableConfigWizardPage.this.selectedViewPrototypes.size() > 0) {
                    ChooseNattableConfigWizardPage.this.setPageComplete(true);
                } else {
                    ChooseNattableConfigWizardPage.this.setPageComplete(false);
                }
            }
        });
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.setInput(viewPrototypes);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    public Collection<ViewPrototype> loadConfigs() {
        ArrayList<ViewPrototype> viewPrototypes = new ArrayList<ViewPrototype>();
        for (ViewPrototype proto : PolicyChecker.getFor((EObject)this.context).getAllPrototypes()) {
            if (!(proto.getRepresentationKind() instanceof PapyrusTable) || !NattableConfigurationRegistry.INSTANCE.canCreateTable(proto.getImplementation(), (Object)this.context).isOK()) continue;
            viewPrototypes.add(proto);
        }
        Collections.sort(viewPrototypes, new ViewPrototype.Comp());
        return viewPrototypes;
    }

    private TableConfiguration getTableConfiguration(TableViewPrototype viewPrototype) {
        if (viewPrototype.getRepresentationKind() instanceof PapyrusTable) {
            PapyrusTable papyrusTable = (PapyrusTable)viewPrototype.getRepresentationKind();
            return papyrusTable.getConfiguration();
        }
        return null;
    }

    public Map<ViewPrototype, Integer> getSelectedViewPrototypes() {
        return this.selectedViewPrototypes;
    }

    public Map<ViewPrototype, String> getTableNames() {
        return this.tableNames;
    }

    public void dispose() {
        if (this.selectedViewPrototypes != null) {
            this.selectedViewPrototypes.clear();
            this.selectedViewPrototypes = null;
        }
        if (this.tableNames != null) {
            this.tableNames.clear();
            this.tableNames = null;
        }
        super.dispose();
    }
}

