/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.core.ui.utils;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.uml.internationalization.edit.providers.InternationalizationUMLItemProviderAdapterFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;

public class CreatorUtils {
    private static final int OFFSET = 5;
    private static AdapterFactoryLabelProvider adapterFactory = null;

    public static FormData getTopFormData() {
        FormData data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        return data;
    }

    public static FormData getFormDataUnder(Control upperControl) {
        FormData data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(upperControl, 5);
        return data;
    }

    public static FormData getFormDataRightAlignedUnder(Control upperControl) {
        FormData data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(upperControl, 5);
        return data;
    }

    public static String getLabel(IGraphicalEditPart editPart) {
        EObject eObject = editPart.resolveSemanticElement();
        return CreatorUtils.getCustomLabelProvider().getText((Object)eObject);
    }

    public static ILabelProvider getCustomLabelProvider() {
        if (adapterFactory == null) {
            adapterFactory = new AdapterFactoryLabelProvider((AdapterFactory)new InternationalizationUMLItemProviderAdapterFactory()){

                public String getText(Object object) {
                    String text = super.getText(object);
                    if (object instanceof EClass) {
                        return text.substring(0, text.indexOf("[") - 1);
                    }
                    return text;
                }
            };
        }
        return adapterFactory;
    }
}

