/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.sequence.RestoreExecutionEndAdvice;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.OLDLifelineXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class SequenceDeleteHelper {
    public static CompoundCommand completeDeleteMessageViewCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, EditPart messagePart) {
        EObject obj;
        if (messagePart instanceof IGraphicalEditPart && (obj = ((IGraphicalEditPart)messagePart).resolveSemanticElement()) instanceof Message) {
            Message message = (Message)obj;
            LifelineEditPart srcLifelinePart = SequenceUtil.getParentLifelinePart(((ConnectionNodeEditPart)messagePart).getSource());
            MessageEnd send = message.getSendEvent();
            SequenceDeleteHelper.addDeleteRelatedTimePartsToCommand(deleteViewsCmd, editingDomain, srcLifelinePart, send);
            LifelineEditPart tgtLifelinePart = SequenceUtil.getParentLifelinePart(((ConnectionNodeEditPart)messagePart).getTarget());
            MessageEnd receive = message.getReceiveEvent();
            SequenceDeleteHelper.addDeleteRelatedTimePartsToCommand(deleteViewsCmd, editingDomain, tgtLifelinePart, receive);
        }
        return deleteViewsCmd;
    }

    private static void addDeleteRelatedTimePartsToCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, LifelineEditPart lifelineEP, MessageEnd messageEnd) {
        if (lifelineEP != null && messageEnd instanceof OccurrenceSpecification) {
            for (Object lifelineChild : lifelineEP.getChildren()) {
                IBorderItemEditPart timePart;
                int positionForEvent;
                if (!(lifelineChild instanceof IBorderItemEditPart) || (positionForEvent = SequenceUtil.positionWhereEventIsLinkedToPart((OccurrenceSpecification)messageEnd, timePart = (IBorderItemEditPart)lifelineChild)) == 0) continue;
                ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)timePart.getModel()));
                deleteViewsCmd.add((Command)deleteTimeViewCommand);
            }
        }
    }

    public static CompoundCommand completeDeleteExecutionSpecificationViewCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, EditPart executionPart) {
        EObject obj;
        if (executionPart instanceof IGraphicalEditPart && (obj = ((IGraphicalEditPart)executionPart).resolveSemanticElement()) instanceof ExecutionSpecification) {
            ExecutionSpecification execution = (ExecutionSpecification)obj;
            LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(executionPart);
            if (lifelinePart != null) {
                for (Object lifelineChild : lifelinePart.getChildren()) {
                    if (!(lifelineChild instanceof IBorderItemEditPart)) continue;
                    IBorderItemEditPart timePart = (IBorderItemEditPart)lifelineChild;
                    OccurrenceSpecification start = execution.getStart();
                    OccurrenceSpecification finish = execution.getFinish();
                    int positionForStart = SequenceUtil.positionWhereEventIsLinkedToPart(start, timePart);
                    int positionForFinish = SequenceUtil.positionWhereEventIsLinkedToPart(finish, timePart);
                    if (positionForStart == 0 && positionForFinish == 0) continue;
                    ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)timePart.getModel()));
                    deleteViewsCmd.add((Command)deleteTimeViewCommand);
                }
            }
        }
        return deleteViewsCmd;
    }

    public static void deleteView(CompositeTransactionalCommand cmd, List<Element> elements, TransactionalEditingDomain editingDomain) {
        for (Element element : elements) {
            SequenceDeleteHelper.deleteView(cmd, element, editingDomain);
        }
    }

    public static void deleteView(CompositeTransactionalCommand cmd, Element element, TransactionalEditingDomain editingDomain) {
        List views = DiagramEditPartsUtil.getEObjectViews((EObject)element);
        for (Object object : views) {
            if (!(object instanceof View)) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, (View)object));
        }
    }

    public static Command completeDeleteMessageCommand(DestroyElementRequest req, EditPart editPart) {
        ICommand deleteCommand;
        EObject selectedEObject = req.getElementToDestroy();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)selectedEObject);
        if (provider != null && (deleteCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
            CompoundCommand command = new CompoundCommand(deleteCommand.getLabel());
            command.add((Command)new ICommandProxy(deleteCommand));
            SequenceDeleteHelper.destroyMessageEvents(command, Arrays.asList(editPart), req.getEditingDomain());
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public static void destroyExecutionOccurrenceSpecification(DestroyElementRequest req, CompoundCommand deleteElementsCommand, ShapeNodeEditPart host, ExecutionSpecification es) {
        DestroyElementRequest delStart = new DestroyElementRequest(req.getEditingDomain(), (EObject)es.getStart(), false);
        deleteElementsCommand.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(delStart)));
        DestroyElementRequest delEnd = new DestroyElementRequest(req.getEditingDomain(), (EObject)es.getFinish(), false);
        deleteElementsCommand.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(delEnd)));
        SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, host, req.getEditingDomain());
        SequenceDeleteHelper.addDestroyExecutionSpecificationChildrenCommand(deleteElementsCommand, req.getEditingDomain(), host);
    }

    public static void destroyMessageEvents(CompoundCommand deleteElementsCommand, ShapeNodeEditPart host, TransactionalEditingDomain transactionalEditingDomain) {
        SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, host.getSourceConnections(), transactionalEditingDomain);
        SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, host.getTargetConnections(), transactionalEditingDomain);
    }

    static void destroyMessageEvents(CompoundCommand deleteElementsCommand, List<?> list, TransactionalEditingDomain transactionalEditingDomain) {
        for (Object o : list) {
            if (!(o instanceof ConnectionEditPart)) continue;
            ConnectionEditPart connectionEP = (ConnectionEditPart)o;
            EObject model = ((ConnectionEditPart)o).resolveSemanticElement();
            if (!(model instanceof Message)) continue;
            Message message = (Message)model;
            MessageEnd receiveEvent = message.getReceiveEvent();
            MessageEnd sendEvent = message.getSendEvent();
            SequenceDeleteHelper.destroyMessageEvent(deleteElementsCommand, sendEvent, transactionalEditingDomain);
            if (receiveEvent instanceof DestructionOccurrenceSpecification) continue;
            SequenceDeleteHelper.destroyMessageEvent(deleteElementsCommand, receiveEvent, transactionalEditingDomain);
        }
    }

    public static void destroyMessageEvent(CompoundCommand deleteElementsCommand, MessageEnd event, TransactionalEditingDomain transactionalEditingDomain) {
        if (event != null) {
            ICommand editCommand;
            DestroyElementRequest myReq = new DestroyElementRequest(transactionalEditingDomain, (EObject)event, false);
            RestoreExecutionEndAdvice provider = new RestoreExecutionEndAdvice();
            if (provider != null && (editCommand = provider.getAfterEditCommand((IEditCommandRequest)myReq)) != null && editCommand.canExecute()) {
                deleteElementsCommand.add((Command)new ICommandProxy(editCommand));
            }
            deleteElementsCommand.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(myReq)));
        }
    }

    static void addDestroyExecutionSpecificationChildrenCommand(CompoundCommand deleteElementsCommand, TransactionalEditingDomain editingDomain, ShapeNodeEditPart part) {
        List<ShapeNodeEditPart> list = OLDLifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(part);
        for (ShapeNodeEditPart p : list) {
            EditCommandRequestWrapper request = new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(p.resolveSemanticElement(), false));
            deleteElementsCommand.add(p.getCommand((Request)request));
            SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, p.getSourceConnections(), editingDomain);
            SequenceDeleteHelper.destroyMessageEvents(deleteElementsCommand, p.getTargetConnections(), editingDomain);
        }
    }
}

