/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.menuContributor;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.NavigationSubMenuButton;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuButton;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnedDiagramsButton
implements NavigationMenuContributor {
    public List<NavigationMenuButton> getButtons(Object fromElement) {
        List<Diagram> diagrams;
        LinkedList<NavigationMenuButton> buttons = new LinkedList<NavigationMenuButton>();
        if (fromElement != null && !(diagrams = this.getOwnedDiagrams(fromElement)).isEmpty()) {
            buttons.add(new NavigationSubMenuButton("Owned diagrams...", null, "Show owned diagrams", diagrams));
        }
        return buttons;
    }

    protected List<Diagram> getOwnedDiagrams(Object fromElement) {
        EObject eObject = EMFHelper.getEObject((Object)fromElement);
        View currentView = NotationHelper.findView((Object)fromElement);
        if (eObject instanceof View || eObject == null) {
            return Collections.emptyList();
        }
        try {
            LinkedList<Diagram> ownedDiagrams = new LinkedList<Diagram>();
            IPageManager pageManager = (IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)eObject);
            for (Object pageObject : pageManager.allPages()) {
                Diagram diagram;
                if (!(pageObject instanceof Diagram) || (diagram = (Diagram)pageObject).getElement() != eObject) continue;
                ownedDiagrams.add(diagram);
            }
            return ownedDiagrams;
        }
        catch (ServiceException ex) {
            return Collections.emptyList();
        }
    }
}

