/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ImportToNonTransformCtxHelper;
import org.eclipse.papyrus.gmf.internal.xpand.Activator;
import org.eclipse.papyrus.gmf.internal.xpand.ResourceManager;
import org.eclipse.papyrus.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.papyrus.gmf.internal.xpand.model.Output;
import org.eclipse.papyrus.gmf.internal.xpand.model.StatefulResource;
import org.eclipse.papyrus.gmf.internal.xpand.model.Variable;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandResource;
import org.eclipse.papyrus.gmf.internal.xpand.util.TypeNameUtil;
import org.eclipse.papyrus.gmf.internal.xpand.xtend.ast.QvtResource;

public class Scope {
    private final Map<String, Variable> globalVars = new HashMap<String, Variable>();
    private final ResourceManager resourceManager;
    private final Output output;
    private final List<XpandAdvice> registeredAdvices = new LinkedList<XpandAdvice>();
    private EvaluationListener evaluationListener;
    private ImportToNonTransformCtxHelper modulesImportHelper;

    public Scope(ResourceManager resourceManager, Collection<Variable> globalVars, Output output) {
        assert (resourceManager != null);
        this.resourceManager = resourceManager;
        this.output = output;
        if (globalVars != null) {
            for (Variable v : globalVars) {
                this.globalVars.put(v.getName(), v);
            }
        }
    }

    protected Scope() {
        this.resourceManager = null;
        this.output = null;
    }

    protected Scope(Output out) {
        this.resourceManager = null;
        this.output = out;
    }

    public EvaluationListener getEvaluationListener() {
        return this.evaluationListener;
    }

    public void setEvaluationListener(EvaluationListener listener) {
        this.evaluationListener = listener;
    }

    public Variable getGlobalVariable(String name) {
        return this.globalVars.get(name);
    }

    public Collection<String> getGlobalVarNames() {
        return this.globalVars.keySet();
    }

    private ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public Output getOutput() {
        return this.output;
    }

    public List<XpandAdvice> getAdvices() {
        return this.registeredAdvices;
    }

    public void registerAdvices(String fullyQualifiedName) {
        XpandAdvice[] as;
        XpandResource tpl = this.findTemplate(fullyQualifiedName);
        if (tpl == null) {
            throw new RuntimeException("Couldn't find template : " + fullyQualifiedName);
        }
        XpandAdvice[] xpandAdviceArray = as = tpl.getAdvices();
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            XpandAdvice advice = xpandAdviceArray[n2];
            if (this.registeredAdvices.contains(advice)) {
                Activator.logWarn("advice " + advice.toString() + " allready registered!");
            } else {
                this.registeredAdvices.add(advice);
            }
            ++n2;
        }
    }

    public XpandResource findTemplate(String templateName, String contextTemplate) {
        String[] possibleNames;
        assert (templateName != null);
        assert (contextTemplate != null);
        if (this.getResourceManager() == null) {
            return null;
        }
        if (!TypeNameUtil.isQualifiedName(contextTemplate)) {
            possibleNames = new String[]{templateName};
        } else {
            String contextNS = TypeNameUtil.withoutLastSegment(contextTemplate);
            possibleNames = new String[]{templateName, String.valueOf(contextNS) + "::" + templateName};
        }
        String[] stringArray = possibleNames;
        int n = possibleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            XpandResource tpl = this.findTemplate(name);
            if (tpl != null) {
                return tpl;
            }
            ++n2;
        }
        return null;
    }

    public XpandResource findTemplate(String templateName) {
        XpandResource resource = this.getResourceManager().loadXpandResource(templateName);
        if (resource instanceof StatefulResource && !((StatefulResource)((Object)resource)).isInitialized()) {
            ((StatefulResource)((Object)resource)).initialize(this);
        }
        return resource;
    }

    public QvtResource findExtension(String extensionName) {
        return this.getResourceManager().loadQvtResource(extensionName);
    }

    public EPackage.Registry createPackageRegistry(String[] metamodelURIs) {
        assert (metamodelURIs != null);
        EPackageRegistryImpl result = new EPackageRegistryImpl();
        String[] stringArray = metamodelURIs;
        int n = metamodelURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            EPackage pkg = Activator.findMetaModel(namespace);
            if (pkg != null) {
                result.put((Object)namespace, (Object)pkg);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            result.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        }
        return result;
    }

    ImportToNonTransformCtxHelper getImportsHelper() {
        if (this.modulesImportHelper == null) {
            this.modulesImportHelper = new ImportToNonTransformCtxHelper();
        }
        return this.modulesImportHelper;
    }
}

