/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.resolver;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

public class ContainmentClosure {
    private WeakReference<EClass> rootRef = new WeakReference<Object>(null);
    private WeakReference<EPackage> scopeRef = new WeakReference<Object>(null);
    private WeakReference<Set<EClass>> closureRef = new WeakReference<Object>(null);

    public synchronized boolean contains(EClass root, EClass type, EPackage scope) {
        assert (root != null);
        assert (type != null);
        assert (scope != null);
        Set<EClass> closure = (Set<EClass>)this.closureRef.get();
        if (this.rootRef.get() != root || this.scopeRef.get() != scope || closure == null) {
            closure = ContainmentClosure.build(root, scope);
            this.rootRef = new WeakReference<EClass>(root);
            this.scopeRef = new WeakReference<EPackage>(scope);
            this.closureRef = new WeakReference<Set<EClass>>(closure);
        }
        return closure.contains(type);
    }

    private static Set<EClass> build(EClass type, EPackage scope) {
        assert (type != null);
        HashSet<EClass> closure = new HashSet<EClass>();
        HashSet<EClass> roots = new HashSet<EClass>();
        roots.add(type);
        while (!roots.isEmpty()) {
            HashSet<EClass> localRoots = roots;
            roots = new HashSet();
            for (EClass root : localRoots) {
                Iterator it1 = root.getEAllContainments().iterator();
                while (it1.hasNext()) {
                    EClass refType = ((EReference)it1.next()).getEReferenceType();
                    if (closure.contains(refType)) continue;
                    closure.add(refType);
                    roots.add(refType);
                    Collection<EClass> subtypes = ContainmentClosure.getSubtypes(refType, scope);
                    if (subtypes == null) continue;
                    for (EClass subtype : subtypes) {
                        if (closure.contains(subtype)) continue;
                        closure.add(subtype);
                        roots.add(subtype);
                    }
                }
            }
        }
        return closure;
    }

    private static Collection<EClass> getSubtypes(EClass type, EPackage scope) {
        HashSet<EClass> subtypes = null;
        TreeIterator it = scope.eAllContents();
        while (it.hasNext()) {
            EClass nextType;
            EObject next = (EObject)it.next();
            if (!(next instanceof EClass) || type == (nextType = (EClass)next) || !type.isSuperTypeOf(nextType)) continue;
            if (subtypes == null) {
                subtypes = new HashSet<EClass>();
            }
            subtypes.add(nextType);
        }
        return subtypes;
    }
}

